/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanzezhen.security.cas;

import com.github.fanzezhen.common.constant.SecurityConstant;
import com.github.fanzezhen.security.cas.CasProperties;
import com.github.fanzezhen.security.facade.UserDetailsServiceFacade;
import com.github.fanzezhen.security.interceptor.MyFilterSecurityInterceptor;
import com.github.fanzezhen.security.property.SecurityProperty;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.sql.DataSource;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.rememberme.JdbcTokenRepositoryImpl;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;

@Configuration
@EnableWebSecurity
public class CasSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Resource
    private CasProperties casProperties;
    @Resource
    private SecurityProperty securityProperty;
    @Resource
    private DataSource dataSource;
    @Resource
    private MyFilterSecurityInterceptor myFilterSecurityInterceptor;
    @Resource
    private UserDetailsServiceFacade userDetailsServiceFacade;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public PersistentTokenRepository persistentTokenRepository() {
        JdbcTokenRepositoryImpl tokenRepository = new JdbcTokenRepositoryImpl();
        tokenRepository.setDataSource(this.dataSource);
        return tokenRepository;
    }

    @Bean
    public CasAuthenticationEntryPoint casAuthenticationEntryPoint() {
        CasAuthenticationEntryPoint casAuthenticationEntryPoint = new CasAuthenticationEntryPoint();
        casAuthenticationEntryPoint.setLoginUrl(this.casProperties.getServerLoginUrl());
        casAuthenticationEntryPoint.setServiceProperties(this.serviceProperties());
        return casAuthenticationEntryPoint;
    }

    @Bean
    public CasAuthenticationFilter casAuthenticationFilter() throws Exception {
        CasAuthenticationFilter casAuthenticationFilter = new CasAuthenticationFilter();
        casAuthenticationFilter.setAuthenticationManager(this.authenticationManager());
        casAuthenticationFilter.setFilterProcessesUrl(this.casProperties.getAppLoginUrl());
        return casAuthenticationFilter;
    }

    @Bean
    public ServiceProperties serviceProperties() {
        ServiceProperties serviceProperties = new ServiceProperties();
        serviceProperties.setService(this.casProperties.getAppUrl() + this.casProperties.getAppLoginUrl());
        serviceProperties.setAuthenticateAllArtifacts(true);
        return serviceProperties;
    }

    @Bean
    public SingleSignOutFilter singleSignOutFilter() {
        SingleSignOutFilter singleSignOutFilter = new SingleSignOutFilter();
        singleSignOutFilter.setLogoutCallbackPath(this.casProperties.getServerUrl());
        singleSignOutFilter.setIgnoreInitConfiguration(true);
        return singleSignOutFilter;
    }

    @Bean
    public LogoutFilter casLogoutFilter() {
        LogoutFilter logoutFilter = new LogoutFilter(this.casProperties.getServerLogoutUrl(), new LogoutHandler[]{new SecurityContextLogoutHandler()});
        logoutFilter.setFilterProcessesUrl(this.casProperties.getAppLogoutUrl());
        return logoutFilter;
    }

    @Bean
    public CasAuthenticationProvider casAuthenticationProvider() {
        CasAuthenticationProvider casAuthenticationProvider = new CasAuthenticationProvider();
        casAuthenticationProvider.setAuthenticationUserDetailsService((AuthenticationUserDetailsService)this.userDetailsServiceFacade);
        casAuthenticationProvider.setUserDetailsService((UserDetailsService)this.userDetailsServiceFacade);
        casAuthenticationProvider.setServiceProperties(this.serviceProperties());
        casAuthenticationProvider.setTicketValidator((TicketValidator)new Cas30ServiceTicketValidator(this.casProperties.getServerUrl()));
        casAuthenticationProvider.setKey("casAuthenticationProviderKey");
        return casAuthenticationProvider;
    }

    public void configure(WebSecurity web) throws Exception {
        super.configure(web);
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        super.configure(auth);
        auth.authenticationProvider((AuthenticationProvider)this.casAuthenticationProvider());
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)http.csrf().and()).headers().frameOptions().sameOrigin().xssProtection().block(true);
        http.csrf().ignoringAntMatchers(SecurityConstant.CSRF_IGNORING_ANT_MATCHERS);
        http.headers().cacheControl().and().contentTypeOptions().and().httpStrictTransportSecurity().and().xssProtection();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.logout().permitAll().and()).authorizeRequests().antMatchers(SecurityConstant.IGNORING_ANT_MATCHERS)).permitAll().antMatchers(this.securityProperty.ignoringAntMatchers)).permitAll().anyRequest()).authenticated();
        ((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.casAuthenticationEntryPoint()).and()).addFilter((Filter)this.casAuthenticationFilter()).addFilterBefore((Filter)this.casLogoutFilter(), LogoutFilter.class).addFilterBefore((Filter)this.singleSignOutFilter(), CasAuthenticationFilter.class);
        http.addFilterBefore((Filter)this.myFilterSecurityInterceptor, FilterSecurityInterceptor.class);
    }
}

