/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.junit;

import com.github.fakemongo.Fongo;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.util.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.List;
import java.util.UUID;
import org.junit.rules.ExternalResource;

public class FongoRule
extends ExternalResource {
    private final boolean realMongo;
    private final String dbName;
    private final Fongo fongo;
    private Mongo mongo;
    private DB db;

    public FongoRule(String dbName, boolean realMongo, MongoClient mongoClientIfReal) {
        this.dbName = dbName;
        this.realMongo = realMongo;
        this.fongo = realMongo ? null : this.newFongo();
        this.mongo = mongoClientIfReal;
    }

    public FongoRule() {
        this(UUID.randomUUID().toString(), false, null);
    }

    public FongoRule(boolean realMongo) {
        this(UUID.randomUUID().toString(), realMongo, null);
    }

    public FongoRule(boolean realMongo, MongoClient mongoClientIfReal) {
        this(UUID.randomUUID().toString(), realMongo, mongoClientIfReal);
    }

    public FongoRule(String dbName, boolean realMongo) {
        this(dbName, realMongo, null);
    }

    public FongoRule(String dbName) {
        this(dbName, false, null);
    }

    public boolean isRealMongo() {
        return this.realMongo;
    }

    protected void before() throws UnknownHostException {
        if (this.realMongo) {
            if (this.mongo == null) {
                this.mongo = new MongoClient();
            }
        } else {
            this.mongo = this.fongo.getMongo();
        }
        this.db = this.mongo.getDB(this.dbName);
    }

    protected void after() {
        this.db.dropDatabase();
    }

    public DBCollection insertJSON(DBCollection coll, String json) {
        List<DBObject> objects = this.parseList(json);
        for (DBObject object : objects) {
            coll.insert(new DBObject[]{object});
        }
        return coll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBCollection insertFile(DBCollection coll, String filename) throws IOException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            while (line != null) {
                coll.insert(new DBObject[]{this.parseDBObject(line)});
                line = br.readLine();
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return coll;
    }

    public List<DBObject> parseList(String json) {
        return (List)this.parse(json);
    }

    public DBObject parseDBObject(String json) {
        return (DBObject)this.parse(json);
    }

    public <T> T parse(String json) {
        return (T)JSON.parse((String)json);
    }

    public DBCollection newCollection() {
        return this.newCollection(UUID.randomUUID().toString());
    }

    public DBCollection newCollection(String collectionName) {
        return this.db.getCollection(collectionName);
    }

    private Fongo newFongo() {
        return new Fongo("test");
    }

    public Fongo getFongo() {
        return this.fongo;
    }

    @Deprecated
    public DB getDb() {
        return this.db;
    }

    @Deprecated
    public DB getDb(String name) {
        return this.mongo.getDB(name);
    }

    public DB getDB() {
        return this.db;
    }

    public DB getDB(String name) {
        return this.mongo.getDB(name);
    }

    public Mongo getMongo() {
        return this.mongo;
    }

    public static String randomName() {
        return UUID.randomUUID().toString();
    }

    public static String randomName(String prefix) {
        return prefix + UUID.randomUUID().toString();
    }
}

