/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.function.impl;

import com.github.f4b6a3.uuid.factory.function.ClockSeqFunction;
import java.util.SplittableRandom;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultClockSeqFunction
implements ClockSeqFunction {
    private AtomicInteger sequence;
    private long lastTimestamp = -1L;
    protected static final ClockSeqPool POOL = new ClockSeqPool();

    public DefaultClockSeqFunction() {
        int initial = POOL.random();
        this.sequence = new AtomicInteger(initial);
    }

    @Override
    public long applyAsLong(long timestamp) {
        if (timestamp > this.lastTimestamp) {
            this.lastTimestamp = timestamp;
            return this.sequence.get();
        }
        this.lastTimestamp = timestamp;
        return this.next();
    }

    public int next() {
        if (this.sequence.incrementAndGet() > 16383) {
            this.sequence.set(0);
        }
        return this.sequence.updateAndGet(POOL::take);
    }

    static final class ClockSeqPool {
        private final byte[] pool = new byte[2048];
        private static final int POOL_SIZE = 16384;
        public static final int POOL_MIN = 0;
        public static final int POOL_MAX = 16383;

        ClockSeqPool() {
        }

        public synchronized int take(int take) {
            int value = take;
            for (int i = 0; i < 16384; ++i) {
                if (this.setBit(value)) {
                    return value;
                }
                ++value;
                value %= 16384;
            }
            this.clearPool();
            this.setBit(value);
            return value;
        }

        public synchronized int random() {
            int random = Math.abs(new SplittableRandom().nextInt()) % 16384;
            return this.take(random);
        }

        private synchronized boolean setBit(int value) {
            boolean clear;
            if (value < 0) {
                return false;
            }
            int byteIndex = value / 8;
            int bitIndex = value % 8;
            int mask = 1 << bitIndex;
            boolean bl = clear = (this.pool[byteIndex] & mask) == 0;
            if (clear) {
                this.pool[byteIndex] = (byte)(this.pool[byteIndex] | mask);
                return true;
            }
            return false;
        }

        public synchronized boolean isUsed(int value) {
            int byteIndex = value / 8;
            int bitIndex = value % 8;
            int mask = 1 << bitIndex;
            boolean clear = (this.pool[byteIndex] & mask) == 0;
            return !clear;
        }

        public synchronized boolean isFree(int value) {
            return !this.isUsed(value);
        }

        public synchronized int countUsed() {
            int counter = 0;
            for (int i = 0; i < 16384; ++i) {
                if (!this.isUsed(i)) continue;
                ++counter;
            }
            return counter;
        }

        public synchronized int countFree() {
            return 16384 - this.countUsed();
        }

        public synchronized void clearPool() {
            for (int i = 0; i < this.pool.length; ++i) {
                this.pool[i] = 0;
            }
        }
    }
}

