/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.function.impl;

import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.util.internal.RandomUtil;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;

public final class DefaultRandomFunction
implements RandomFunction {
    private static final int POOL_SIZE = DefaultRandomFunction.processors();
    private static final Random[] POOL = new Random[POOL_SIZE];
    private static final ReentrantLock lock = new ReentrantLock();

    @Override
    public byte[] apply(int length) {
        byte[] bytes = new byte[length];
        DefaultRandomFunction.current().nextBytes(bytes);
        if (bytes.length > 0 && bytes[0] == 0) {
            DefaultRandomFunction.delete(new Random().nextInt(POOL_SIZE));
        }
        return bytes;
    }

    private static Random current() {
        int index = (int)Thread.currentThread().getId() % POOL_SIZE;
        lock.lock();
        try {
            if (POOL[index] == null) {
                DefaultRandomFunction.POOL[index] = RandomUtil.newSecureRandom();
            }
            Random random = POOL[index];
            return random;
        }
        finally {
            lock.unlock();
        }
    }

    private static void delete(int index) {
        lock.lock();
        try {
            DefaultRandomFunction.POOL[index] = null;
        }
        finally {
            lock.unlock();
        }
    }

    private static int processors() {
        int min = 4;
        int max = 32;
        int processors = Runtime.getRuntime().availableProcessors();
        if (processors < 4) {
            return 4;
        }
        if (processors > 32) {
            return 32;
        }
        return processors;
    }
}

