/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import java.time.Clock;
import java.util.function.LongSupplier;

public abstract class AbstCombFactory
extends AbstRandomBasedFactory {
    protected LongSupplier timeFunction;

    protected AbstCombFactory(UuidVersion version, Builder<?, ?> builder) {
        super(version, builder);
        this.timeFunction = builder.getTimeFunction();
    }

    public static abstract class Builder<T, B extends Builder<T, B>>
    extends AbstRandomBasedFactory.Builder<T, B> {
        protected LongSupplier timeFunction;

        protected LongSupplier getTimeFunction() {
            if (this.timeFunction == null) {
                this.timeFunction = () -> System.currentTimeMillis();
            }
            return this.timeFunction;
        }

        public B withClock(Clock clock) {
            if (clock != null) {
                this.timeFunction = () -> clock.millis();
            }
            return (B)this;
        }

        public B withTimeFunction(LongSupplier timeFunction) {
            this.timeFunction = timeFunction;
            return (B)this;
        }
    }
}

