/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.alt;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public final class GUID
implements Serializable,
Comparable<GUID> {
    private static final long serialVersionUID = -6082258105369032877L;
    private final long msb;
    private final long lsb;
    public static final GUID NIL = new GUID(0L, 0L);
    public static final GUID MAX = new GUID(-1L, -1L);
    public static final GUID NAMESPACE_DNS = new GUID(7757371264673321425L, -9172705715073830712L);
    public static final GUID NAMESPACE_URL = new GUID(7757371268968288721L, -9172705715073830712L);
    public static final GUID NAMESPACE_OID = new GUID(7757371273263256017L, -9172705715073830712L);
    public static final GUID NAMESPACE_X500 = new GUID(7757371281853190609L, -9172705715073830712L);
    public static final byte LOCAL_DOMAIN_PERSON = 0;
    public static final byte LOCAL_DOMAIN_GROUP = 1;
    public static final byte LOCAL_DOMAIN_ORG = 2;
    public static final int GUID_CHARS = 36;
    public static final int GUID_BYTES = 16;
    private static final long MASK_04 = 15L;
    private static final long MASK_08 = 255L;
    private static final long MASK_12 = 4095L;
    private static final long MASK_16 = 65535L;
    private static final long MASK_32 = 0xFFFFFFFFL;
    private static final long MULTICAST = 0x10000000000L;
    private static final GUID HASHSPACE_SHA2_256 = new GUID(4590055878433719396L, -7134290745402751939L);

    public GUID(GUID guid) {
        if (guid == null) {
            throw new IllegalArgumentException("Null GUID");
        }
        this.msb = guid.msb;
        this.lsb = guid.lsb;
    }

    public GUID(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Null UUID");
        }
        this.msb = uuid.getMostSignificantBits();
        this.lsb = uuid.getLeastSignificantBits();
    }

    public GUID(long mostSignificantBits, long leastSignificantBits) {
        this.msb = mostSignificantBits;
        this.lsb = leastSignificantBits;
    }

    public GUID(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException("Invalid GUID bytes");
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.msb = buffer.getLong();
        this.lsb = buffer.getLong();
    }

    public GUID(String string) {
        this(Parser.parse(string));
    }

    public static GUID v1() {
        long time = GUID.gregorian();
        long msb = time << 32 | time >>> 16 & 0xFFFF0000L | time >>> 48 & 0xFFFL;
        long lsb = ThreadLocalRandom.current().nextLong() | 0x10000000000L;
        return GUID.version(msb, lsb, 1);
    }

    public static GUID v2(byte localDomain, int localIdentifier) {
        GUID uuid = GUID.v1();
        long msb = uuid.msb & 0xFFFFFFFFL | ((long)localIdentifier & 0xFFFFFFFFL) << 32;
        long lsb = uuid.lsb & 0x3F00FFFFFFFFFFFFL | ((long)localDomain & 0xFFL) << 48;
        return GUID.version(msb, lsb, 2);
    }

    public static GUID v3(GUID namespace, String name) {
        return GUID.hash(3, "MD5", null, namespace, name);
    }

    public static GUID v4() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long msb = random.nextLong();
        long lsb = random.nextLong();
        return GUID.version(msb, lsb, 4);
    }

    public static GUID v5(GUID namespace, String name) {
        return GUID.hash(5, "SHA-1", null, namespace, name);
    }

    public static GUID v6() {
        long time = GUID.gregorian();
        long msb = (time & 0xFFFFFFFFFFFFF000L) << 4 | time & 0xFFFL;
        long lsb = ThreadLocalRandom.current().nextLong() | 0x10000000000L;
        return GUID.version(msb, lsb, 6);
    }

    public static GUID v7() {
        long time = System.currentTimeMillis();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long msb = time << 16 | random.nextLong() & 0xFFFFL;
        long lsb = random.nextLong();
        return GUID.version(msb, lsb, 7);
    }

    @Deprecated
    public static GUID v8(GUID namespace, String name) {
        return GUID.hash(8, "SHA-256", HASHSPACE_SHA2_256, namespace, name);
    }

    public static boolean valid(String string) {
        return Parser.valid(string);
    }

    public byte[] toBytes() {
        return ByteBuffer.allocate(16).putLong(this.msb).putLong(this.lsb).array();
    }

    public String toString() {
        return this.toUUID().toString();
    }

    public UUID toUUID() {
        return new UUID(this.msb, this.lsb);
    }

    public int version() {
        return this.toUUID().version();
    }

    public int hashCode() {
        long bits = this.msb ^ this.lsb;
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != GUID.class) {
            return false;
        }
        GUID that = (GUID)other;
        if (this.lsb != that.lsb) {
            return false;
        }
        return this.msb == that.msb;
    }

    @Override
    public int compareTo(GUID other) {
        GUID that = other != null ? other : NIL;
        long min = Long.MIN_VALUE;
        long a = this.msb + Long.MIN_VALUE;
        long b = that.msb + Long.MIN_VALUE;
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        long c = this.lsb + Long.MIN_VALUE;
        long d = that.lsb + Long.MIN_VALUE;
        if (c > d) {
            return 1;
        }
        if (c < d) {
            return -1;
        }
        return 0;
    }

    private static long gregorian() {
        Instant now = Instant.now();
        long greg = 12219292800L;
        long nano = now.getNano();
        long secs = now.getEpochSecond() + 12219292800L;
        long time = secs * 10000000L + nano / 100L;
        return time;
    }

    private static GUID hash(int version, String algorithm, GUID hashspace, GUID namespace, String name) {
        ByteBuffer ns;
        MessageDigest hasher = null;
        try {
            hasher = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(String.format("%s not supported", algorithm));
        }
        if (hashspace != null) {
            ns = ByteBuffer.allocate(16);
            ns.putLong(hashspace.msb);
            ns.putLong(hashspace.lsb);
            hasher.update(ns.array());
        }
        if (namespace != null) {
            ns = ByteBuffer.allocate(16);
            ns.putLong(namespace.msb);
            ns.putLong(namespace.lsb);
            hasher.update(ns.array());
        }
        hasher.update(name.getBytes(StandardCharsets.UTF_8));
        ByteBuffer hash = ByteBuffer.wrap(hasher.digest());
        long msb = hash.getLong();
        long lsb = hash.getLong();
        return GUID.version(msb, lsb, version);
    }

    private static GUID version(long hi, long lo, int version) {
        long msb = hi & 0xFFFFFFFFFFFF0FFFL | ((long)version & 0xFL) << 12;
        long lsb = lo & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new GUID(msb, lsb);
    }

    long getMostSignificantBits() {
        return this.msb;
    }

    long getLeastSignificantBits() {
        return this.lsb;
    }

    static final class Parser {
        private static final byte[] VALUES = new byte[256];

        Parser() {
        }

        static GUID parse(String string) {
            if (!Parser.valid(string)) {
                throw new IllegalArgumentException("Invalid GUID string: " + string);
            }
            long msb = 0L;
            long lsb = 0L;
            msb |= (long)VALUES[string.charAt(0)] << 60;
            msb |= (long)VALUES[string.charAt(1)] << 56;
            msb |= (long)VALUES[string.charAt(2)] << 52;
            msb |= (long)VALUES[string.charAt(3)] << 48;
            msb |= (long)VALUES[string.charAt(4)] << 44;
            msb |= (long)VALUES[string.charAt(5)] << 40;
            msb |= (long)VALUES[string.charAt(6)] << 36;
            msb |= (long)VALUES[string.charAt(7)] << 32;
            msb |= (long)VALUES[string.charAt(9)] << 28;
            msb |= (long)VALUES[string.charAt(10)] << 24;
            msb |= (long)VALUES[string.charAt(11)] << 20;
            msb |= (long)VALUES[string.charAt(12)] << 16;
            msb |= (long)VALUES[string.charAt(14)] << 12;
            msb |= (long)VALUES[string.charAt(15)] << 8;
            msb |= (long)VALUES[string.charAt(16)] << 4;
            msb |= (long)VALUES[string.charAt(17)];
            lsb |= (long)VALUES[string.charAt(19)] << 60;
            lsb |= (long)VALUES[string.charAt(20)] << 56;
            lsb |= (long)VALUES[string.charAt(21)] << 52;
            lsb |= (long)VALUES[string.charAt(22)] << 48;
            lsb |= (long)VALUES[string.charAt(24)] << 44;
            lsb |= (long)VALUES[string.charAt(25)] << 40;
            lsb |= (long)VALUES[string.charAt(26)] << 36;
            lsb |= (long)VALUES[string.charAt(27)] << 32;
            lsb |= (long)VALUES[string.charAt(28)] << 28;
            lsb |= (long)VALUES[string.charAt(29)] << 24;
            lsb |= (long)VALUES[string.charAt(30)] << 20;
            lsb |= (long)VALUES[string.charAt(31)] << 16;
            lsb |= (long)VALUES[string.charAt(32)] << 12;
            lsb |= (long)VALUES[string.charAt(33)] << 8;
            lsb |= (long)VALUES[string.charAt(34)] << 4;
            return new GUID(msb, lsb |= (long)VALUES[string.charAt(35)]);
        }

        static boolean valid(String string) {
            if (string == null || string.length() != 36) {
                return false;
            }
            int dashes = 0;
            for (int i = 0; i < 36; ++i) {
                char chr = string.charAt(i);
                byte val = VALUES[chr];
                if (val >= 0) continue;
                if ((i == 8 || i == 13 || i == 18 || i == 23) && chr == '-') {
                    ++dashes;
                    continue;
                }
                return false;
            }
            return dashes == 4;
        }

        static {
            Arrays.fill(VALUES, (byte)-1);
            Parser.VALUES[48] = 0;
            Parser.VALUES[49] = 1;
            Parser.VALUES[50] = 2;
            Parser.VALUES[51] = 3;
            Parser.VALUES[52] = 4;
            Parser.VALUES[53] = 5;
            Parser.VALUES[54] = 6;
            Parser.VALUES[55] = 7;
            Parser.VALUES[56] = 8;
            Parser.VALUES[57] = 9;
            Parser.VALUES[65] = 10;
            Parser.VALUES[66] = 11;
            Parser.VALUES[67] = 12;
            Parser.VALUES[68] = 13;
            Parser.VALUES[69] = 14;
            Parser.VALUES[70] = 15;
            Parser.VALUES[97] = 10;
            Parser.VALUES[98] = 11;
            Parser.VALUES[99] = 12;
            Parser.VALUES[100] = 13;
            Parser.VALUES[101] = 14;
            Parser.VALUES[102] = 15;
        }
    }
}

