/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.uri;

import com.github.f4b6a3.uuid.codec.StringCodec;
import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import java.net.URI;
import java.util.UUID;

public class UriCodec
implements UuidCodec<URI> {
    public static final UriCodec INSTANCE = new UriCodec();
    private static final String URN_PREFIX = "urn:uuid:";

    @Override
    public URI encode(UUID uuid) {
        return URI.create(URN_PREFIX + StringCodec.INSTANCE.encode(uuid));
    }

    @Override
    public UUID decode(URI uri) {
        if (uri == null || !uri.toString().startsWith(URN_PREFIX)) {
            throw new InvalidUuidException("Invalid URI: \"" + uri + "\"");
        }
        return StringCodec.INSTANCE.decode(uri.toString());
    }
}

