/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base.function;

import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.codec.base.function.BaseNDecoder;
import com.github.f4b6a3.uuid.exception.UuidCodecException;
import java.util.UUID;

public final class BaseNRemainderDecoder
extends BaseNDecoder {
    private final int n;
    private static final long HALF_LONG_MASK = 0xFFFFFFFFL;

    public BaseNRemainderDecoder(BaseN base) {
        super(base);
        this.n = base.getRadix();
    }

    @Override
    public UUID apply(String string) {
        char[] chars = this.toCharArray(string);
        int[] number = new int[4];
        for (char c : chars) {
            int[] product = new int[4];
            long remainder = this.map.get(c);
            int overflow = this.multiply(number, this.n, remainder, product);
            if (overflow > 0) {
                throw new UuidCodecException("Invalid string (overflow): \"" + new String(chars) + "\"");
            }
            number = product;
        }
        long msb = ((long)number[0] & 0xFFFFFFFFL) << 32 | (long)number[1] & 0xFFFFFFFFL;
        long lsb = ((long)number[2] & 0xFFFFFFFFL) << 32 | (long)number[3] & 0xFFFFFFFFL;
        return new UUID(msb, lsb);
    }

    private int multiply(int[] number, int multiplier, long remainder, int[] product) {
        long temporary = 0L;
        long overflow = remainder;
        temporary = ((long)number[3] & 0xFFFFFFFFL) * (long)multiplier + overflow;
        if (temporary > 0L) {
            product[3] = (int)temporary;
            overflow = temporary >>> 32;
        }
        if ((temporary = ((long)number[2] & 0xFFFFFFFFL) * (long)multiplier + overflow) > 0L) {
            product[2] = (int)temporary;
            overflow = temporary >>> 32;
        }
        if ((temporary = ((long)number[1] & 0xFFFFFFFFL) * (long)multiplier + overflow) > 0L) {
            product[1] = (int)temporary;
            overflow = temporary >>> 32;
        }
        if ((temporary = ((long)number[0] & 0xFFFFFFFFL) * (long)multiplier + overflow) > 0L) {
            product[0] = (int)temporary;
            overflow = temporary >>> 32;
        }
        return (int)overflow;
    }
}

