/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator;

import com.github.f4b6a3.uuid.codec.BinaryCodec;
import com.github.f4b6a3.uuid.codec.StringCodec;
import com.github.f4b6a3.uuid.creator.AbstractUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public abstract class AbstractNameBasedUuidCreator
extends AbstractUuidCreator {
    protected byte[] namespace = null;
    protected final String algorithm;
    protected boolean locked = false;
    protected static final String ALGORITHM_MD5 = "MD5";
    protected static final String ALGORITHM_SHA1 = "SHA-1";
    private static final String EXCEPTION_MESSAGE = "Namespace can not be changed.";

    public AbstractNameBasedUuidCreator(UuidVersion version, String algorithm) {
        super(version);
        this.algorithm = algorithm;
    }

    public UUID create(byte[] name) {
        if (!this.locked) {
            this.locked = true;
        }
        return this.create(this.namespace, name);
    }

    public UUID create(String name) {
        if (!this.locked) {
            this.locked = true;
        }
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(this.namespace, n);
    }

    public UUID create(UUID namespace, byte[] name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(namespace);
        return this.create(ns, name);
    }

    public UUID create(UUID namespace, String name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(namespace);
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    public UUID create(String namespace, byte[] name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(StringCodec.INSTANCE.decode(namespace));
        return this.create(ns, name);
    }

    public UUID create(String namespace, String name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(StringCodec.INSTANCE.decode(namespace));
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    public UUID create(UuidNamespace namespace, byte[] name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(namespace.getValue());
        return this.create(ns, name);
    }

    public UUID create(UuidNamespace namespace, String name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(namespace.getValue());
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    private UUID create(byte[] namespace, byte[] name) {
        MessageDigest hasher;
        byte[] hash = null;
        try {
            hasher = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Message digest algorithm not available: " + this.algorithm, e);
        }
        if (namespace != null) {
            hasher.update(namespace);
        }
        hash = hasher.digest(name);
        return this.getUuid(hash);
    }

    public <T extends AbstractNameBasedUuidCreator> T withNamespace(UUID namespace) {
        if (this.locked) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE);
        }
        this.namespace = BinaryCodec.INSTANCE.encode(namespace);
        return (T)this;
    }

    public <T extends AbstractNameBasedUuidCreator> T withNamespace(String namespace) {
        if (this.locked) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE);
        }
        this.namespace = BinaryCodec.INSTANCE.encode(StringCodec.INSTANCE.decode(namespace));
        return (T)this;
    }

    public <T extends AbstractNameBasedUuidCreator> T withNamespace(UuidNamespace namespace) {
        if (this.locked) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE);
        }
        this.namespace = BinaryCodec.INSTANCE.encode(namespace.getValue());
        return (T)this;
    }
}

