/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.name;

import com.github.f4b6a3.uuid.codec.BinaryCodec;
import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.codec.base.Base64UrlCodec;
import com.github.f4b6a3.uuid.codec.base.BaseNCodec;
import java.util.UUID;

public final class NcnameCodec
implements UuidCodec<String> {
    private final int base;
    private final int length;
    private final int shift;
    private final BaseNCodec codec;
    private static final UuidCodec<byte[]> CODEC_BYTES = new BinaryCodec();
    private static final char[][] VERSION_CHARS = new char[][]{{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P'}, {'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'}};
    private static final long[] VERSION_MAP = new long[128];
    private static final char DECODER_PADDING = 'A';

    public NcnameCodec() {
        this(new Base64UrlCodec());
    }

    public NcnameCodec(BaseNCodec codec) {
        this.codec = codec;
        this.base = codec.getBase().getNumber();
        this.length = codec.getBase().getLength();
        switch (this.base) {
            case 32: {
                this.shift = 1;
                break;
            }
            case 64: {
                this.shift = 2;
                break;
            }
            default: {
                this.shift = 0;
            }
        }
    }

    @Override
    public String encode(UUID uuid) {
        int version = uuid.version();
        byte[] bytes = CODEC_BYTES.encode(uuid);
        int[] ints = NcnameCodec.toInts(bytes);
        int variant = (ints[2] & 0xF0000000) >>> 24;
        ints[1] = ints[1] & 0xFFFF0000 | (ints[1] & 0xFFF) << 4 | (ints[2] & 0xFFFFFFF) >>> 24;
        ints[2] = (ints[2] & 0xFFFFFF) << 8 | ints[3] >>> 24;
        ints[3] = ints[3] << 8 | variant;
        bytes = NcnameCodec.fromInts(ints);
        bytes[15] = (byte)((bytes[15] & 0xFF) >>> this.shift);
        UUID uuuu = CODEC_BYTES.decode(bytes);
        String encoded = this.codec.encode(uuuu).substring(0, this.length - 1);
        char v = this.base == 64 ? VERSION_CHARS[0][version] : VERSION_CHARS[1][version];
        return v + encoded;
    }

    @Override
    public UUID decode(String ncname) {
        int version = (int)VERSION_MAP[ncname.charAt(0)];
        String substring = ncname.substring(1, ncname.length());
        UUID uuid = this.codec.decode(substring + 'A');
        byte[] bytes = CODEC_BYTES.encode(uuid);
        bytes[15] = (byte)(bytes[15] << this.shift);
        version &= 0xF;
        int[] ints = NcnameCodec.toInts(bytes);
        int variant = (ints[3] & 0xF0) << 24;
        ints[3] = ints[3] >>> 8;
        ints[3] = ints[3] | (ints[2] & 0xFF) << 24;
        ints[2] = ints[2] >>> 8;
        ints[2] = ints[2] | ((ints[1] & 0xF) << 24 | variant);
        ints[1] = ints[1] & 0xFFFF0000 | version << 12 | ints[1] >>> 4 & 0xFFF;
        bytes = NcnameCodec.fromInts(ints);
        return CODEC_BYTES.decode(bytes);
    }

    private static int[] toInts(byte[] bytes) {
        int[] ints = new int[4];
        ints[0] = (int)((long)ints[0] | ((long)bytes[0] & 0xFFL) << 24);
        ints[0] = (int)((long)ints[0] | ((long)bytes[1] & 0xFFL) << 16);
        ints[0] = (int)((long)ints[0] | ((long)bytes[2] & 0xFFL) << 8);
        ints[0] = (int)((long)ints[0] | (long)bytes[3] & 0xFFL);
        ints[1] = (int)((long)ints[1] | ((long)bytes[4] & 0xFFL) << 24);
        ints[1] = (int)((long)ints[1] | ((long)bytes[5] & 0xFFL) << 16);
        ints[1] = (int)((long)ints[1] | ((long)bytes[6] & 0xFFL) << 8);
        ints[1] = (int)((long)ints[1] | (long)bytes[7] & 0xFFL);
        ints[2] = (int)((long)ints[2] | ((long)bytes[8] & 0xFFL) << 24);
        ints[2] = (int)((long)ints[2] | ((long)bytes[9] & 0xFFL) << 16);
        ints[2] = (int)((long)ints[2] | ((long)bytes[10] & 0xFFL) << 8);
        ints[2] = (int)((long)ints[2] | (long)bytes[11] & 0xFFL);
        ints[3] = (int)((long)ints[3] | ((long)bytes[12] & 0xFFL) << 24);
        ints[3] = (int)((long)ints[3] | ((long)bytes[13] & 0xFFL) << 16);
        ints[3] = (int)((long)ints[3] | ((long)bytes[14] & 0xFFL) << 8);
        ints[3] = (int)((long)ints[3] | (long)bytes[15] & 0xFFL);
        return ints;
    }

    private static byte[] fromInts(int[] ints) {
        byte[] bytes = new byte[]{(byte)(ints[0] >>> 24), (byte)(ints[0] >>> 16), (byte)(ints[0] >>> 8), (byte)ints[0], (byte)(ints[1] >>> 24), (byte)(ints[1] >>> 16), (byte)(ints[1] >>> 8), (byte)ints[1], (byte)(ints[2] >>> 24), (byte)(ints[2] >>> 16), (byte)(ints[2] >>> 8), (byte)ints[2], (byte)(ints[3] >>> 24), (byte)(ints[3] >>> 16), (byte)(ints[3] >>> 8), (byte)ints[3]};
        return bytes;
    }

    static {
        for (int i = 0; i < VERSION_MAP.length; ++i) {
            NcnameCodec.VERSION_MAP[i] = -1L;
        }
        NcnameCodec.VERSION_MAP[65] = 0L;
        NcnameCodec.VERSION_MAP[66] = 1L;
        NcnameCodec.VERSION_MAP[67] = 2L;
        NcnameCodec.VERSION_MAP[68] = 3L;
        NcnameCodec.VERSION_MAP[69] = 4L;
        NcnameCodec.VERSION_MAP[70] = 5L;
        NcnameCodec.VERSION_MAP[71] = 6L;
        NcnameCodec.VERSION_MAP[72] = 7L;
        NcnameCodec.VERSION_MAP[73] = 8L;
        NcnameCodec.VERSION_MAP[74] = 9L;
        NcnameCodec.VERSION_MAP[75] = 10L;
        NcnameCodec.VERSION_MAP[76] = 11L;
        NcnameCodec.VERSION_MAP[77] = 12L;
        NcnameCodec.VERSION_MAP[78] = 13L;
        NcnameCodec.VERSION_MAP[79] = 14L;
        NcnameCodec.VERSION_MAP[80] = 15L;
        NcnameCodec.VERSION_MAP[97] = 0L;
        NcnameCodec.VERSION_MAP[98] = 1L;
        NcnameCodec.VERSION_MAP[99] = 2L;
        NcnameCodec.VERSION_MAP[100] = 3L;
        NcnameCodec.VERSION_MAP[101] = 4L;
        NcnameCodec.VERSION_MAP[102] = 5L;
        NcnameCodec.VERSION_MAP[103] = 6L;
        NcnameCodec.VERSION_MAP[104] = 7L;
        NcnameCodec.VERSION_MAP[105] = 8L;
        NcnameCodec.VERSION_MAP[106] = 9L;
        NcnameCodec.VERSION_MAP[107] = 10L;
        NcnameCodec.VERSION_MAP[108] = 11L;
        NcnameCodec.VERSION_MAP[109] = 12L;
        NcnameCodec.VERSION_MAP[110] = 13L;
        NcnameCodec.VERSION_MAP[111] = 14L;
        NcnameCodec.VERSION_MAP[112] = 15L;
    }
}

