/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.exception.InvalidUuidException;

public final class UuidValidator {
    private UuidValidator() {
    }

    public static boolean isValid(byte[] uuid) {
        return uuid != null && uuid.length == 16;
    }

    public static void validate(byte[] uuid) {
        if (uuid == null || uuid.length != 16) {
            throw new InvalidUuidException("Invalid UUID byte array.");
        }
    }

    public static boolean isValid(String uuid) {
        return uuid != null && uuid.length() != 0 && UuidValidator.isUuidString(uuid.toCharArray());
    }

    public static boolean isValid(char[] uuid) {
        return uuid != null && uuid.length != 0 && UuidValidator.isUuidString(uuid);
    }

    public static void validate(String uuid) {
        if (uuid == null || uuid.length() == 0 || !UuidValidator.isUuidString(uuid.toCharArray())) {
            throw new InvalidUuidException("Invalid UUID: \"" + uuid + "\"");
        }
    }

    public static void validate(char[] uuid) {
        if (uuid == null || uuid.length == 0 || !UuidValidator.isUuidString(uuid)) {
            throw new InvalidUuidException("Invalid UUID: \"" + (uuid == null ? null : new String(uuid)) + "\"");
        }
    }

    protected static boolean isUuidString(char[] c) {
        int hyphens = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '-' && (i == 8 || i == 13 || i == 18 || i == 23)) {
                ++hyphens;
                continue;
            }
            if (c[i] >= '0' && c[i] <= '9' || c[i] >= 'a' && c[i] <= 'f' || c[i] >= 'A' && c[i] <= 'F') continue;
            return false;
        }
        return c.length == 36 && hyphens == 4 || c.length == 32 && hyphens == 0;
    }
}

