/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.exception.InvalidUuidException;

public class UuidValidator {
    private UuidValidator() {
    }

    protected static boolean isValid(byte[] uuid) {
        return uuid != null && uuid.length == 16;
    }

    public static void validate(byte[] uuid) {
        if (!UuidValidator.isValid(uuid)) {
            throw new InvalidUuidException("Invalid UUID byte array.");
        }
    }

    public static boolean isValid(String uuid) {
        return uuid != null && UuidValidator.isValid(uuid.toCharArray());
    }

    public static boolean isValid(char[] chars) {
        if (chars == null) {
            return false;
        }
        if (chars.length == 32) {
            return UuidValidator.isHexadecimal(chars);
        }
        if (chars.length == 36 && chars[8] == '-' && chars[13] == '-' && chars[18] == '-' && chars[23] == '-') {
            return UuidValidator.isHexadecimalWithHyphen(chars);
        }
        return false;
    }

    public static void validate(String uuid) {
        if (!UuidValidator.isValid(uuid)) {
            throw new InvalidUuidException("Invalid UUID string.");
        }
    }

    public static void validate(char[] uuid) {
        if (!UuidValidator.isValid(uuid)) {
            throw new InvalidUuidException("Invalid UUID char array.");
        }
    }

    private static boolean isHexadecimal(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    private static boolean isHexadecimalWithHyphen(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c == '-') continue;
            return false;
        }
        return true;
    }
}

