/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.exception.IllegalUuidException;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.UuidUtil;
import com.github.f4b6a3.uuid.util.UuidValidator;
import java.util.UUID;

public class UuidConverter {
    private UuidConverter() {
    }

    public static byte[] toBytes(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] msbBytes = ByteUtil.toBytes(msb);
        byte[] lsbBytes = ByteUtil.toBytes(lsb);
        return ByteUtil.concat(msbBytes, lsbBytes);
    }

    public static UUID fromBytes(byte[] bytes) {
        byte[] msbBytes = ByteUtil.copy(bytes, 0, 8);
        byte[] lsbBytes = ByteUtil.copy(bytes, 8, 16);
        long msb = ByteUtil.toNumber(msbBytes);
        long lsb = ByteUtil.toNumber(lsbBytes);
        return new UUID(msb, lsb);
    }

    public static String toString(UUID uuid) {
        String hex = ByteUtil.toHexadecimal(UuidConverter.toBytes(uuid));
        StringBuffer buffer = new StringBuffer(hex);
        buffer.insert(8, '-');
        buffer.insert(13, '-');
        buffer.insert(18, '-');
        buffer.insert(23, '-');
        return buffer.toString();
    }

    public static UUID fromString(String uuid) {
        UuidValidator.validate(uuid);
        String hex = uuid.replaceAll("[^0-9a-fA-F]", "");
        return UuidConverter.fromBytes(ByteUtil.toBytes(hex));
    }

    public static UUID toTimeBasedUuid(UUID uuid) {
        if (!UuidUtil.isTimeOrdered(uuid)) {
            throw new IllegalUuidException(String.format("Not a time-ordered UUID: %s.", uuid.toString()));
        }
        long timestamp = UuidUtil.extractTimestamp(uuid);
        long msb = (timestamp & 0xFFF000000000000L) >>> 48 | (timestamp & 0xFFFF00000000L) >>> 16 | (timestamp & 0xFFFFFFFFL) << 32 | 0x1000L;
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    public static UUID toTimeOrderedUuid(UUID uuid) {
        if (!UuidUtil.isTimeBased(uuid)) {
            throw new IllegalUuidException(String.format("Not a time-based UUID: %s.", uuid.toString()));
        }
        long timestamp = UuidUtil.extractTimestamp(uuid);
        long msb = (timestamp & 0xFFFFFFFFFFFF000L) << 4 | timestamp & 0xFFFL | 0x6000L;
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    public static UUID toAndFromMsGuid(UUID uuid) {
        long msb = UuidConverter.toAndFromMsGuidMostSignificantBits(uuid.getMostSignificantBits());
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    private static long toAndFromMsGuidMostSignificantBits(long msb) {
        long bits = 0L;
        bits |= (msb & 0xFF00000000000000L) >>> 24;
        bits |= (msb & 0xFF000000000000L) >>> 8;
        bits |= (msb & 0xFF0000000000L) << 8;
        bits |= (msb & 0xFF00000000L) << 24;
        bits |= (msb & 0xFF000000L) >>> 8;
        bits |= (msb & 0xFF0000L) << 8;
        bits |= (msb & 0xFF00L) >>> 8;
        return bits |= (msb & 0xFFL) << 8;
    }
}

