/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.exception.InvalidUuidException;

public class UuidValidator {
    public static final String UUID_PATTERN = "^([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}|[0-9a-fA-F]{32})$";

    private UuidValidator() {
    }

    protected static boolean isValid(byte[] uuid) {
        return uuid != null && uuid.length == 16;
    }

    public static void validate(byte[] uuid) {
        if (!UuidValidator.isValid(uuid)) {
            throw new InvalidUuidException("Invalid UUID byte array.");
        }
    }

    public static boolean isValid(String uuid) {
        return uuid != null && (uuid.length() == 32 || uuid.length() == 36) && uuid.matches(UUID_PATTERN);
    }

    public static void validate(String uuid) {
        if (!UuidValidator.isValid(uuid)) {
            throw new InvalidUuidException("Invalid UUID string.");
        }
    }
}

