/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator;

import com.github.f4b6a3.commons.random.Xorshift128PlusRandom;
import com.github.f4b6a3.commons.util.ByteUtil;
import com.github.f4b6a3.commons.util.FingerprintUtil;
import com.github.f4b6a3.commons.util.RandomUtil;
import com.github.f4b6a3.uuid.creator.AbstractUuidCreator;
import com.github.f4b6a3.uuid.creator.NoArgumentsUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

public abstract class AbstractRandomBasedUuidCreator
extends AbstractUuidCreator
implements NoArgumentsUuidCreator {
    protected Random random;

    public AbstractRandomBasedUuidCreator() {
    }

    public AbstractRandomBasedUuidCreator(UuidVersion version) {
        super(version);
    }

    @Override
    public UUID create() {
        long lsb;
        long msb;
        if (this.random == null) {
            byte[] bytes = new byte[16];
            RandomUtil.get().nextBytes(bytes);
            msb = ByteUtil.toNumber((byte[])bytes, (int)0, (int)8);
            lsb = ByteUtil.toNumber((byte[])bytes, (int)8, (int)16);
        } else if (this.random instanceof SecureRandom) {
            byte[] bytes = new byte[16];
            this.random.nextBytes(bytes);
            msb = ByteUtil.toNumber((byte[])bytes, (int)0, (int)8);
            lsb = ByteUtil.toNumber((byte[])bytes, (int)8, (int)16);
        } else {
            msb = this.random.nextLong();
            lsb = this.random.nextLong();
        }
        return new UUID(this.applyVersionBits(msb), this.applyVariantBits(lsb));
    }

    public synchronized <T extends AbstractRandomBasedUuidCreator> T withRandomGenerator(Random random) {
        this.random = random;
        return (T)this;
    }

    public synchronized <T extends AbstractRandomBasedUuidCreator> T withFastRandomGenerator() {
        int salt = (int)FingerprintUtil.getFingerprint();
        this.random = new Xorshift128PlusRandom(salt);
        return (T)this;
    }
}

