/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.exception.UuidCreatorException;
import com.github.f4b6a3.uuid.factory.abst.AbstractUuidCreator;
import com.github.f4b6a3.uuid.factory.abst.NoArgumentsUuidCreator;
import com.github.f4b6a3.uuid.random.Xorshift128PlusRandom;
import com.github.f4b6a3.uuid.timestamp.TimestampStrategy;
import com.github.f4b6a3.uuid.timestamp.UnixMillisecondsTimestampStretegy;
import com.github.f4b6a3.uuid.util.FingerprintUtil;
import com.github.f4b6a3.uuid.util.RandomUtil;
import java.util.Random;
import java.util.UUID;

public class LexicalOrderGuidCreator
extends AbstractUuidCreator
implements NoArgumentsUuidCreator {
    protected static final long MAX_LOW = -1L;
    protected static final long MAX_HIGH = 65535L;
    protected long previousTimestamp;
    protected boolean enableOverflowException = true;
    protected Random random;
    protected long low;
    protected long high;
    protected static final String OVERFLOW_MESSAGE = "The system caused an overflow in the generator by requesting too many GUIDs.";
    protected TimestampStrategy timestampStrategy;

    public LexicalOrderGuidCreator() {
        this.reset();
        this.timestampStrategy = new UnixMillisecondsTimestampStretegy();
    }

    @Override
    public synchronized UUID create() {
        long timestamp = this.getTimestamp();
        long msb = timestamp << 16 | this.high;
        long lsb = this.low;
        return new UUID(msb, lsb);
    }

    protected synchronized long getTimestamp() {
        long timestamp = this.timestampStrategy.getTimestamp();
        if (timestamp == this.previousTimestamp) {
            this.increment();
        } else {
            this.reset();
        }
        this.previousTimestamp = timestamp;
        return timestamp;
    }

    protected synchronized void reset() {
        if (this.random == null) {
            this.low = RandomUtil.getInstance().nextLong();
            this.high = RandomUtil.getInstance().nextLong() & 0xFFFFL;
        } else {
            this.low = this.random.nextLong();
            this.high = this.random.nextLong() & 0xFFFFL;
        }
    }

    protected synchronized void increment() {
        if (this.low++ == -1L && this.high++ == 65535L) {
            this.high = 0L;
            if (this.enableOverflowException) {
                throw new UuidCreatorException(OVERFLOW_MESSAGE);
            }
        }
    }

    public synchronized <T extends LexicalOrderGuidCreator> T withTimestampStrategy(TimestampStrategy timestampStrategy) {
        this.timestampStrategy = timestampStrategy;
        return (T)this;
    }

    public synchronized <T extends LexicalOrderGuidCreator> T withRandomGenerator(Random random) {
        this.random = random;
        return (T)this;
    }

    public synchronized <T extends LexicalOrderGuidCreator> T withFastRandomGenerator() {
        int salt = (int)FingerprintUtil.getFingerprint();
        this.random = new Xorshift128PlusRandom(salt);
        return (T)this;
    }

    public synchronized <T extends LexicalOrderGuidCreator> T withoutOverflowException() {
        this.enableOverflowException = false;
        return (T)this;
    }
}

