/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.sequence;

import com.github.f4b6a3.uuid.sequence.Sequence;

public abstract class AbstractSequence
implements Sequence {
    protected long value;
    public final long minValue;
    public final long maxValue;

    protected AbstractSequence(long min, long max) {
        this.minValue = min;
        this.maxValue = max;
        this.value = this.minValue;
    }

    @Override
    public long current() {
        return this.value;
    }

    @Override
    public long next() {
        if (this.value >= this.maxValue) {
            this.value = this.minValue;
            return this.value;
        }
        return ++this.value;
    }

    @Override
    public long min() {
        return this.minValue;
    }

    @Override
    public long max() {
        return this.maxValue;
    }

    @Override
    public void reset() {
        this.value = this.minValue;
    }

    @Override
    public void set(long value) {
        if (value < this.minValue || value > this.maxValue) {
            this.reset();
        }
        this.value = value;
    }
}

