/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.exception.UuidCreatorException;
import com.github.f4b6a3.uuid.factory.abst.AbstractUuidCreator;
import com.github.f4b6a3.uuid.factory.abst.NoArgumentsUuidCreator;
import com.github.f4b6a3.uuid.timestamp.EpochMilliTimestampStretegy;
import com.github.f4b6a3.uuid.timestamp.TimestampStrategy;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.RandomUtil;
import java.util.UUID;

public class LexicalOrderGuidCreator
extends AbstractUuidCreator
implements NoArgumentsUuidCreator {
    private long previousTimestamp;
    private long field1;
    private long field2;
    private long field3;
    protected static final String OVERFLOW_MESSAGE = "The system requested more than 2^80 Lexical Order GUIDs within the same millisecond.";
    protected TimestampStrategy timestampStrategy;

    public LexicalOrderGuidCreator() {
        this.reset();
        this.timestampStrategy = new EpochMilliTimestampStretegy();
    }

    @Override
    public synchronized UUID create() {
        long timestamp = this.timestampStrategy.getTimestamp();
        if (timestamp <= this.previousTimestamp) {
            this.increment();
        }
        this.previousTimestamp = timestamp;
        long msb = timestamp << 16 | this.field3;
        long lsb = this.field2 << 32 | this.field1;
        return new UUID(msb, lsb);
    }

    protected void reset() {
        byte[] randomness = new byte[10];
        RandomUtil.nextBytes(randomness);
        this.field3 = ByteUtil.toNumber(randomness, 0, 2);
        this.field2 = ByteUtil.toNumber(randomness, 2, 6);
        this.field1 = ByteUtil.toNumber(randomness, 6, 10);
    }

    protected void increment() {
        ++this.field1;
        if (this.field1 > 0xFFFFFFFFL) {
            this.field1 = 0L;
            ++this.field2;
            if (this.field2 > 0xFFFFFFFFL) {
                this.field2 = 0L;
                ++this.field3;
                if (this.field3 > 65535L) {
                    this.field3 = 0L;
                    throw new UuidCreatorException(OVERFLOW_MESSAGE);
                }
            }
        }
    }

    public <T extends LexicalOrderGuidCreator> T withTimestampStrategy(TimestampStrategy timestampStrategy) {
        this.timestampStrategy = timestampStrategy;
        return (T)this;
    }
}

