/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.NetworkData;
import com.github.f4b6a3.uuid.util.NodeIdentifierUtil;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class SystemDataUtil {
    protected static MessageDigest md;

    private SystemDataUtil() {
    }

    public static long getSystemId(String salt) {
        String hash = SystemDataUtil.getSystemDataHash(salt);
        long number = ByteUtil.toNumber(hash) & 0xFFFFFFFFFFFFL;
        return NodeIdentifierUtil.setMulticastNodeIdentifier(number);
    }

    public static String getSystemDataHash(String salt) {
        md = SystemDataUtil.getMessageDigest();
        String os = SystemDataUtil.getOperatingSystem();
        String jvm = SystemDataUtil.getJavaVirtualMachine();
        String net = SystemDataUtil.getNetwork();
        String res = SystemDataUtil.getResources();
        String string = String.join((CharSequence)" ", os, jvm, net, res, salt);
        byte[] bytes = string.getBytes();
        byte[] hash = md.digest(bytes);
        return ByteUtil.toHexadecimal(hash);
    }

    public static String getOperatingSystem() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String arch = System.getProperty("os.arch");
        return String.join((CharSequence)" ", name, version, arch);
    }

    public static String getJavaVirtualMachine() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        String rtName = System.getProperty("java.runtime.name");
        String rtVersion = System.getProperty("java.runtime.version");
        String vmName = System.getProperty("java.vm.name");
        String vmVersion = System.getProperty("java.vm.version");
        return String.join((CharSequence)" ", vendor, version, rtName, rtVersion, vmName, vmVersion);
    }

    public static String getResources() {
        int procs = SystemDataUtil.getAvailableProcessors();
        long memory = SystemDataUtil.getMaxMemory();
        return String.join((CharSequence)" ", procs + " processors ", memory + " bytes");
    }

    public static int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static String getNetwork() {
        List<NetworkData> networkDataList;
        NetworkData networkData = SystemDataUtil.getNetworkData();
        if (networkData == null && (networkDataList = SystemDataUtil.getNetworkDataList()) != null && !networkDataList.isEmpty()) {
            networkData = networkDataList.get(0);
        }
        if (networkData == null) {
            return null;
        }
        return networkData.toString();
    }

    public static NetworkData getNetworkData() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            return SystemDataUtil.buildNetworkData(networkInterface, inetAddress);
        }
        catch (SocketException | UnknownHostException e) {
            return null;
        }
    }

    public static List<NetworkData> getNetworkDataList() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            ArrayList<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            HashSet<NetworkData> networkDataHashSet = new HashSet<NetworkData>();
            for (NetworkInterface networkInterface : networkInterfaces) {
                NetworkData networkData = SystemDataUtil.buildNetworkData(networkInterface, inetAddress);
                if (networkData == null) continue;
                networkDataHashSet.add(networkData);
            }
            return new ArrayList<NetworkData>(networkDataHashSet);
        }
        catch (NullPointerException | SocketException | UnknownHostException e) {
            return Collections.emptyList();
        }
    }

    private static NetworkData buildNetworkData(NetworkInterface networkInterface, InetAddress inetAddress) throws SocketException {
        if (SystemDataUtil.isPhysicalNetworkInterface(networkInterface)) {
            String hostName = inetAddress != null ? inetAddress.getHostName() : null;
            String hostCanonicalName = inetAddress != null ? inetAddress.getCanonicalHostName() : null;
            String interfaceName = networkInterface.getName();
            String interfaceDisplayName = networkInterface.getDisplayName();
            String interfaceHardwareAddress = ByteUtil.toHexadecimal(networkInterface.getHardwareAddress());
            List<String> interfaceAddresses = SystemDataUtil.getInterfaceAddresses(networkInterface);
            NetworkData networkData = new NetworkData();
            networkData.setHostName(hostName);
            networkData.setHostCanonicalName(hostCanonicalName);
            networkData.setInterfaceName(interfaceName);
            networkData.setInterfaceDisplayName(interfaceDisplayName);
            networkData.setInterfaceHardwareAddress(interfaceHardwareAddress);
            networkData.setInterfaceAddresses(interfaceAddresses);
            return networkData;
        }
        return null;
    }

    private static boolean isPhysicalNetworkInterface(NetworkInterface networkInterface) {
        try {
            return networkInterface != null && networkInterface.isUp() && !networkInterface.isLoopback() && !networkInterface.isVirtual();
        }
        catch (SocketException e) {
            return false;
        }
    }

    private static List<String> getInterfaceAddresses(NetworkInterface networkInterface) {
        HashSet<String> addresses = new HashSet<String>();
        List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
        if (interfaceAddresses != null && !interfaceAddresses.isEmpty()) {
            for (InterfaceAddress addr : interfaceAddresses) {
                if (addr.getAddress() == null) continue;
                addresses.add(addr.getAddress().getHostAddress());
            }
        }
        return new ArrayList<String>(addresses);
    }

    private static MessageDigest getMessageDigest() {
        if (md == null) {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalError("Message digest algorithm not supported.", e);
            }
        }
        return md;
    }
}

