/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.nodeid;

import com.github.f4b6a3.uuid.nodeid.NodeIdentifierStrategy;
import com.github.f4b6a3.uuid.random.Xorshift128PlusRandom;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.NodeIdentifierUtil;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;

public class SystemNodeIdentifierStrategy
implements NodeIdentifierStrategy {
    protected long nodeIdentifier;
    protected Random random;
    protected static MessageDigest md;

    public SystemNodeIdentifierStrategy() {
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("Message digest algorithm not supported.", e);
        }
        this.random = new Xorshift128PlusRandom();
        this.nodeIdentifier = this.getSystemNodeIdentifier();
    }

    @Override
    public long getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    protected long getSystemNodeIdentifier() {
        byte[] bytes = null;
        byte[] hash = null;
        String hn = this.getHostName();
        String ha = this.getNetworkInterface();
        String os = this.getOperatingSystem();
        String vm = this.getJavaVirtualMachine();
        String string = String.format("%s %s %s %s", hn, ha, os, vm);
        bytes = string.getBytes();
        hash = md.digest(bytes);
        return NodeIdentifierUtil.setMulticastNodeIdentifier(ByteUtil.toNumber(hash));
    }

    protected String getHostName() {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            if (hostname == null || hostname.isEmpty()) {
                return this.getRandomHexadecimal();
            }
            return hostname;
        }
        catch (UnknownHostException e) {
            return this.getRandomHexadecimal();
        }
    }

    protected String getOperatingSystem() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String arch = System.getProperty("os.arch");
        return String.format("%s %s %s", name, version, arch);
    }

    protected String getJavaVirtualMachine() {
        String vmName = System.getProperty("java.vm.name");
        String vmVersion = System.getProperty("java.vm.version");
        String rtName = System.getProperty("java.runtime.name");
        String rtVersion = System.getProperty("java.runtime.version");
        return String.format("%s %s %s %s", vmName, vmVersion, rtName, rtVersion);
    }

    protected String getNetworkInterface() {
        try {
            Enumeration<NetworkInterface> enm = NetworkInterface.getNetworkInterfaces();
            while (enm.hasMoreElements()) {
                NetworkInterface nic = enm.nextElement();
                List<InterfaceAddress> list = nic.getInterfaceAddresses();
                byte[] mac = nic.getHardwareAddress();
                if (mac == null || list.isEmpty() || nic.isLoopback() || nic.isVirtual()) continue;
                String hw = ByteUtil.toHexadecimal(mac);
                String ip = list.get(0).getAddress().getHostAddress();
                return String.format("%s %s", hw, ip);
            }
        }
        catch (NullPointerException | SocketException e) {
            return this.getRandomHexadecimal();
        }
        return this.getRandomHexadecimal();
    }

    protected String getRandomHexadecimal() {
        return ByteUtil.toHexadecimal(this.random.nextLong());
    }
}

