/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.JsonParseException;
import com.github.erosb.jsonsKema.TextLocation;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\bH\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/erosb/jsonsKema/SourceWalker;", "", "input", "Ljava/io/InputStream;", "reader", "Ljava/io/Reader;", "(Ljava/io/InputStream;Ljava/io/Reader;)V", "lineNumber", "", "location", "Lcom/github/erosb/jsonsKema/TextLocation;", "getLocation", "()Lcom/github/erosb/jsonsKema/TextLocation;", "position", "consume", "token", "", "curr", "", "currInt", "forward", "", "reachedEOF", "", "readUntil", "terminator", "skipWhitespaces", "json-sKema"})
final class SourceWalker {
    @NotNull
    private final Reader reader;
    private int lineNumber;
    private int position;

    public SourceWalker(@NotNull InputStream input, @NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
        this.lineNumber = 1;
        this.position = 1;
    }

    public /* synthetic */ SourceWalker(InputStream inputStream, Reader reader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            reader = new BufferedReader(new InputStreamReader(inputStream));
        }
        this(inputStream, reader);
    }

    public final char curr() {
        int currInt = this.currInt();
        if (currInt == -1) {
            throw new JsonParseException("Unexpected EOF", this.getLocation());
        }
        return (char)currInt;
    }

    private final int currInt() {
        this.reader.mark(1);
        int c = this.reader.read();
        this.reader.reset();
        return c;
    }

    @NotNull
    public final SourceWalker skipWhitespaces() {
        while (true) {
            this.reader.mark(1);
            int c = this.reader.read();
            char c2 = (char)c;
            if (c == -1 || c2 != ' ' && c2 != '\t' && c2 != '\n' && c2 != '\r') break;
            if (c2 == '\r' && this.currInt() == 10) {
                this.reader.read();
            }
            if (c2 == '\n' || c2 == '\r') {
                this.position = 1;
                ++this.lineNumber;
                continue;
            }
            ++this.position;
        }
        this.reader.reset();
        return this;
    }

    public final boolean reachedEOF() {
        return this.currInt() == -1;
    }

    @NotNull
    public final SourceWalker consume(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        token.chars().forEach(arg_0 -> SourceWalker.consume$lambda$0(this, arg_0));
        return this;
    }

    public final void forward() {
        this.reader.read();
        ++this.position;
    }

    @NotNull
    public final String readUntil(char terminator) {
        StringBuilder buffer = new StringBuilder();
        while (true) {
            char ch = this.curr();
            this.forward();
            if (ch == terminator) break;
            buffer.append(ch);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @NotNull
    public final TextLocation getLocation() {
        return new TextLocation(this.lineNumber, this.position, null, 4, null);
    }

    private static final void consume$lambda$0(SourceWalker this$0, int i) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        char ch = this$0.curr();
        char toChar = (char)i;
        if (toChar != ch) {
            throw new JsonParseException("Unexpected character found: " + ch, this$0.getLocation());
        }
        this$0.reader.read();
        ++this$0.position;
        int cfr_ignored_0 = this$0.position;
    }
}

