/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.BufferReadingSourceWalker;
import com.github.erosb.jsonsKema.DuplicateObjectPropertyException;
import com.github.erosb.jsonsKema.JsonArray;
import com.github.erosb.jsonsKema.JsonBoolean;
import com.github.erosb.jsonsKema.JsonNull;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonObject;
import com.github.erosb.jsonsKema.JsonParseException;
import com.github.erosb.jsonsKema.JsonParserKt;
import com.github.erosb.jsonsKema.JsonPointer;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.JsonValue;
import com.github.erosb.jsonsKema.PathElem;
import com.github.erosb.jsonsKema.SchemaLoaderKt;
import com.github.erosb.jsonsKema.SourceLocation;
import com.github.erosb.jsonsKema.SourceWalker;
import com.github.erosb.jsonsKema.StringReadingSourceWalker;
import com.github.erosb.jsonsKema.TextLocation;
import com.github.erosb.jsonsKema.TooDeeplyNestedValueException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001+B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB%\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\fB%\b\u0017\u0012\u0006\u0010\n\u001a\u00020\r\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u000eB%\b\u0017\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0011J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\u0012\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020!H\u0002J\t\u0010*\u001a\u00020\u0016H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00060%j\u0002`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/github/erosb/jsonsKema/JsonParser;", "", "walker", "Lcom/github/erosb/jsonsKema/SourceWalker;", "documentSource", "Ljava/net/URI;", "maxNestingDepth", "", "<init>", "(Lcom/github/erosb/jsonsKema/SourceWalker;Ljava/net/URI;I)V", "schemaJson", "", "(Ljava/lang/String;Ljava/net/URI;I)V", "Ljava/io/Reader;", "(Ljava/io/Reader;Ljava/net/URI;I)V", "schemaInputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Ljava/net/URI;I)V", "currentNestingDepth", "pathElem", "Lcom/github/erosb/jsonsKema/PathElem;", "parse", "Lcom/github/erosb/jsonsKema/JsonValue;", "parseValue", "sourceLocation", "Lcom/github/erosb/jsonsKema/SourceLocation;", "toNumber", "Lcom/github/erosb/jsonsKema/JsonNumber;", "str", "location", "toDouble", "parseNumber", "appendDigits", "", "optParseSign", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "parseString", "Lcom/github/erosb/jsonsKema/JsonString;", "putReadLiteralToNestingPath", "invoke", "PathElemBackedList", "json-sKema"})
@SourceDebugExtension(value={"SMAP\nJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonParser.kt\ncom/github/erosb/jsonsKema/JsonParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,460:1\n1#2:461\n108#3:462\n80#3,22:463\n*S KotlinDebug\n*F\n+ 1 JsonParser.kt\ncom/github/erosb/jsonsKema/JsonParser\n*L\n430#1:462\n430#1:463,22\n*E\n"})
public final class JsonParser {
    @NotNull
    private final SourceWalker walker;
    @NotNull
    private final URI documentSource;
    private final int maxNestingDepth;
    private int currentNestingDepth;
    @NotNull
    private PathElem pathElem;
    @NotNull
    private final StringBuilder sb;

    /*
     * WARNING - void declaration
     */
    private JsonParser(SourceWalker walker, URI documentSource, int maxNestingDepth) {
        void it;
        StringBuilder stringBuilder;
        this.walker = walker;
        this.documentSource = documentSource;
        this.maxNestingDepth = maxNestingDepth;
        this.pathElem = new PathElem(null, "");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        JsonParser jsonParser = this;
        boolean bl = false;
        it.ensureCapacity(100000);
        jsonParser.sb = stringBuilder;
    }

    @JvmOverloads
    public JsonParser(@NotNull String schemaJson, @NotNull URI documentSource, int maxNestingDepth) {
        Intrinsics.checkNotNullParameter((Object)schemaJson, (String)"schemaJson");
        Intrinsics.checkNotNullParameter((Object)documentSource, (String)"documentSource");
        char[] cArray = schemaJson.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        this(new StringReadingSourceWalker(cArray, documentSource), documentSource, maxNestingDepth);
    }

    public /* synthetic */ JsonParser(String string, URI uRI, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            uRI = SchemaLoaderKt.getDEFAULT_BASE_URI();
        }
        if ((n2 & 4) != 0) {
            n = JsonParserKt.access$getDEFAULT_MAX_NESTING_DEPTH$p();
        }
        this(string, uRI, n);
    }

    @JvmOverloads
    public JsonParser(@NotNull Reader schemaJson, @NotNull URI documentSource, int maxNestingDepth) {
        Intrinsics.checkNotNullParameter((Object)schemaJson, (String)"schemaJson");
        Intrinsics.checkNotNullParameter((Object)documentSource, (String)"documentSource");
        this(new BufferReadingSourceWalker(schemaJson, documentSource), documentSource, maxNestingDepth);
    }

    public /* synthetic */ JsonParser(Reader reader, URI uRI, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            uRI = SchemaLoaderKt.getDEFAULT_BASE_URI();
        }
        if ((n2 & 4) != 0) {
            n = JsonParserKt.access$getDEFAULT_MAX_NESTING_DEPTH$p();
        }
        this(reader, uRI, n);
    }

    @JvmOverloads
    public JsonParser(@NotNull InputStream schemaInputStream, @NotNull URI documentSource, int maxNestingDepth) {
        Intrinsics.checkNotNullParameter((Object)schemaInputStream, (String)"schemaInputStream");
        Intrinsics.checkNotNullParameter((Object)documentSource, (String)"documentSource");
        this(new BufferReadingSourceWalker(schemaInputStream, documentSource), documentSource, maxNestingDepth);
    }

    public /* synthetic */ JsonParser(InputStream inputStream, URI uRI, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            uRI = SchemaLoaderKt.getDEFAULT_BASE_URI();
        }
        if ((n2 & 4) != 0) {
            n = JsonParserKt.access$getDEFAULT_MAX_NESTING_DEPTH$p();
        }
        this(inputStream, uRI, n);
    }

    @NotNull
    public final JsonValue parse() {
        JsonValue jsonValue = this.parseValue();
        if (!this.walker.reachedEOF()) {
            throw new JsonParseException("Extraneous character found: " + this.walker.curr(), this.walker.getLocation());
        }
        return jsonValue;
    }

    private final JsonValue parseValue() {
        JsonValue jsonValue;
        char curr;
        block14: {
            block20: {
                block19: {
                    SourceLocation location;
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block13: {
                                        this.walker.skipWhitespaces();
                                        int n = this.currentNestingDepth;
                                        this.currentNestingDepth = n + 1;
                                        if (this.currentNestingDepth > this.maxNestingDepth) {
                                            throw new TooDeeplyNestedValueException(this.sourceLocation(), this.maxNestingDepth);
                                        }
                                        curr = this.walker.curr();
                                        location = this.sourceLocation();
                                        jsonValue = null;
                                        if (curr != 'n') break block13;
                                        this.walker.consume(JsonParserKt.access$getNULL_TOKEN$p());
                                        jsonValue = new JsonNull(location);
                                        break block14;
                                    }
                                    if (curr != '\"') break block15;
                                    jsonValue = JsonParser.parseString$default(this, false, 1, null);
                                    break block14;
                                }
                                if (curr != '[') break block16;
                                this.walker.forward();
                                this.walker.skipWhitespaces();
                                List elements = new ArrayList();
                                while (this.walker.curr() != ']') {
                                    boolean commaCharFound = false;
                                    this.pathElem = new PathElem(this.pathElem, String.valueOf(elements.size()));
                                    JsonValue element = this.parseValue();
                                    elements.add(element);
                                    Intrinsics.checkNotNull((Object)this.pathElem.getParent());
                                    this.pathElem = this.pathElem;
                                    if (this.walker.curr() == ',') {
                                        commaCharFound = true;
                                        this.walker.forward();
                                    }
                                    this.walker.skipWhitespaces();
                                    char curr2 = this.walker.curr();
                                    if (commaCharFound || this.walker.curr() == ']') continue;
                                    throw new JsonParseException("Unexpected character found: " + curr2 + ". Expected ',', ']'", this.sourceLocation());
                                }
                                this.walker.forward();
                                jsonValue = new JsonArray(CollectionsKt.toList((Iterable)elements), location);
                                break block14;
                            }
                            if (curr != '{') break block17;
                            Map properties = new LinkedHashMap();
                            this.walker.forward();
                            this.walker.skipWhitespaces();
                            while (this.walker.curr() != '}') {
                                boolean commaCharFound = false;
                                JsonString propName = this.parseString(true);
                                this.walker.skipWhitespaces();
                                this.walker.consume(':');
                                this.walker.skipWhitespaces();
                                JsonValue propValue = this.parseValue();
                                Intrinsics.checkNotNull((Object)this.pathElem.getParent());
                                this.pathElem = this.pathElem;
                                JsonValue previous = properties.put(propName, propValue);
                                if (previous != null) {
                                    Object v0;
                                    block12: {
                                        Iterable iterable = properties.keySet();
                                        for (Object t : iterable) {
                                            JsonString it = (JsonString)t;
                                            boolean bl = false;
                                            if (!Intrinsics.areEqual((Object)it.getValue(), (Object)propName.getValue())) continue;
                                            v0 = t;
                                            break block12;
                                        }
                                        v0 = null;
                                    }
                                    Intrinsics.checkNotNull(v0);
                                    JsonString jsonString = propName;
                                    JsonString jsonString2 = v0;
                                    throw new DuplicateObjectPropertyException(jsonString2, jsonString);
                                }
                                if (this.walker.curr() == ',') {
                                    commaCharFound = true;
                                    this.walker.forward();
                                }
                                this.walker.skipWhitespaces();
                                char curr3 = this.walker.curr();
                                if (commaCharFound || curr3 == '}') continue;
                                throw new JsonParseException("Unexpected character found: " + curr3 + ". Expected ',', '}'", this.sourceLocation());
                            }
                            this.walker.forward();
                            jsonValue = new JsonObject(properties, location);
                            break block14;
                        }
                        if (curr != 't') break block18;
                        this.walker.consume(JsonParserKt.access$getTRUE_TOKEN$p());
                        jsonValue = new JsonBoolean(true, location);
                        break block14;
                    }
                    if (curr != 'f') break block19;
                    this.walker.consume(JsonParserKt.access$getFALSE_TOKEN$p());
                    jsonValue = new JsonBoolean(false, location);
                    break block14;
                }
                if (curr == '-') break block20;
                boolean bl = '0' <= curr ? curr < ':' : false;
                if (!bl) break block14;
            }
            jsonValue = this.parseNumber();
        }
        if (jsonValue == null) {
            throw new JsonParseException("unexpected character '" + curr + '\'', this.sourceLocation());
        }
        this.currentNestingDepth += -1;
        this.walker.skipWhitespaces();
        return jsonValue;
    }

    private final SourceLocation sourceLocation() {
        TextLocation textLocation = this.walker.getLocation();
        SourceLocation sourceLocation = new SourceLocation(textLocation.getLineNumber(), textLocation.getPosition(), new JsonPointer((List)((Object)new PathElemBackedList(this.pathElem))), this.documentSource);
        return sourceLocation;
    }

    private final JsonNumber toNumber(String str, SourceLocation location) {
        try {
            return new JsonNumber(Integer.parseInt(str), location);
        }
        catch (NumberFormatException ex) {
            return new JsonNumber(new BigInteger(str), location);
        }
    }

    private final JsonNumber toDouble(String str, SourceLocation location) {
        try {
            double value = Double.parseDouble(str);
            if (Double.isInfinite(value)) {
                return new JsonNumber(new BigDecimal(str), location);
            }
            return new JsonNumber(value, location);
        }
        catch (NumberFormatException ex) {
            return new JsonNumber(new BigDecimal(str), location);
        }
    }

    private final JsonNumber parseNumber() {
        SourceLocation location;
        block5: {
            location = this.sourceLocation();
            StringsKt.clear((StringBuilder)this.sb);
            this.optParseSign();
            do {
                char c;
                boolean bl = '0' <= (c = this.walker.curr()) ? c < ':' : false;
                if (!bl || this.walker.reachedEOF()) break block5;
                this.sb.append(this.walker.curr());
                this.walker.forward();
            } while (!this.walker.reachedEOF());
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return this.toNumber(string, location);
        }
        if (this.walker.curr() != '.' && Character.toLowerCase(this.walker.curr()) != 'e') {
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return this.toNumber(string, location);
        }
        this.sb.append(this.walker.curr());
        this.walker.forward();
        this.optParseSign();
        if (this.appendDigits()) {
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return this.toDouble(string, location);
        }
        if (this.walker.curr() != 'e' && this.walker.curr() != 'E') {
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return this.toDouble(string, location);
        }
        this.sb.append(this.walker.curr());
        this.walker.forward();
        this.optParseSign();
        if (this.appendDigits()) {
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return this.toDouble(string, location);
        }
        String string = this.sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.toDouble(string, location);
    }

    private final boolean appendDigits() {
        block1: {
            do {
                char c;
                boolean bl = '0' <= (c = this.walker.curr()) ? c < ':' : false;
                if (!bl) break block1;
                this.sb.append(this.walker.curr());
                this.walker.forward();
            } while (!this.walker.reachedEOF());
            return true;
        }
        return false;
    }

    private final void optParseSign() {
        char curr = this.walker.curr();
        switch (curr) {
            case '+': 
            case '-': {
                this.sb.append(curr);
                this.walker.forward();
            }
        }
    }

    private final JsonString parseString(boolean putReadLiteralToNestingPath) {
        SourceLocation loc = this.sourceLocation();
        this.walker.consume('\"');
        boolean nextCharIsEscaped = false;
        StringsKt.clear((StringBuilder)this.sb);
        boolean reachedClosingQuote = false;
        while (!this.walker.reachedEOF()) {
            char ch = this.walker.curr();
            if (ch == '\\') {
                if (nextCharIsEscaped) {
                    nextCharIsEscaped = false;
                } else {
                    nextCharIsEscaped = true;
                    this.walker.forward();
                    continue;
                }
            }
            if (ch == '\"' && !nextCharIsEscaped) {
                this.walker.forward();
                reachedClosingQuote = true;
                break;
            }
            if (ch == 'u' && nextCharIsEscaped) {
                String hexLiteral;
                TextLocation location = this.walker.getLocation();
                int n = 0;
                Object[] objectArray = new Character[4];
                while (n < 4) {
                    int n2 = n++;
                    objectArray[n2] = Character.valueOf('0');
                }
                Object[] buf = objectArray;
                for (int i = 0; i < 4; ++i) {
                    this.walker.forward();
                    buf[i] = Character.valueOf(this.walker.curr());
                }
                String $this$trim$iv = hexLiteral = ArraysKt.joinToString$default((Object[])buf, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = it == '0';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String trimmedHexLiteral = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                try {
                    int codePoint = ((CharSequence)trimmedHexLiteral).length() == 0 ? 0 : Integer.parseInt(trimmedHexLiteral, 16);
                    StringBuilder stringBuilder = this.sb.append((char)codePoint);
                }
                catch (NumberFormatException e) {
                    throw new JsonParseException("invalid unicode sequence: " + hexLiteral, location);
                }
            } else {
                this.sb.append(ch);
            }
            nextCharIsEscaped = false;
            this.walker.forward();
        }
        if (!reachedClosingQuote) {
            throw new JsonParseException("Unexpected EOF", this.sourceLocation());
        }
        String string = this.sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String literal = string;
        if (putReadLiteralToNestingPath) {
            this.pathElem = new PathElem(this.pathElem, literal);
            loc = new SourceLocation(loc.getLineNumber(), loc.getPosition(), new JsonPointer((List)((Object)new PathElemBackedList(this.pathElem))), this.documentSource);
        }
        return new JsonString(literal, loc);
    }

    static /* synthetic */ JsonString parseString$default(JsonParser jsonParser, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return jsonParser.parseString(bl);
    }

    @NotNull
    public final JsonValue invoke() {
        return this.parse();
    }

    @JvmOverloads
    public JsonParser(@NotNull String schemaJson, @NotNull URI documentSource) {
        Intrinsics.checkNotNullParameter((Object)schemaJson, (String)"schemaJson");
        Intrinsics.checkNotNullParameter((Object)documentSource, (String)"documentSource");
        this(schemaJson, documentSource, 0, 4, null);
    }

    @JvmOverloads
    public JsonParser(@NotNull String schemaJson) {
        Intrinsics.checkNotNullParameter((Object)schemaJson, (String)"schemaJson");
        this(schemaJson, null, 0, 6, null);
    }

    @JvmOverloads
    public JsonParser(@NotNull Reader schemaJson, @NotNull URI documentSource) {
        Intrinsics.checkNotNullParameter((Object)schemaJson, (String)"schemaJson");
        Intrinsics.checkNotNullParameter((Object)documentSource, (String)"documentSource");
        this(schemaJson, documentSource, 0, 4, null);
    }

    @JvmOverloads
    public JsonParser(@NotNull Reader schemaJson) {
        Intrinsics.checkNotNullParameter((Object)schemaJson, (String)"schemaJson");
        this(schemaJson, null, 0, 6, null);
    }

    @JvmOverloads
    public JsonParser(@NotNull InputStream schemaInputStream, @NotNull URI documentSource) {
        Intrinsics.checkNotNullParameter((Object)schemaInputStream, (String)"schemaInputStream");
        Intrinsics.checkNotNullParameter((Object)documentSource, (String)"documentSource");
        this(schemaInputStream, documentSource, 0, 4, null);
    }

    @JvmOverloads
    public JsonParser(@NotNull InputStream schemaInputStream) {
        Intrinsics.checkNotNullParameter((Object)schemaInputStream, (String)"schemaInputStream");
        this(schemaInputStream, null, 0, 6, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0002J\u0011\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u000eH\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/github/erosb/jsonsKema/JsonParser$PathElemBackedList;", "Lkotlin/collections/AbstractList;", "", "last", "Lcom/github/erosb/jsonsKema/PathElem;", "<init>", "(Lcom/github/erosb/jsonsKema/PathElem;)V", "backingList", "", "getBackingList", "()Ljava/util/List;", "setBackingList", "(Ljava/util/List;)V", "size", "", "getSize", "()I", "get", "index", "json-sKema"})
    private static final class PathElemBackedList
    extends AbstractList<String> {
        @NotNull
        private final PathElem last;
        @Nullable
        private List<String> backingList;

        public PathElemBackedList(@NotNull PathElem last) {
            Intrinsics.checkNotNullParameter((Object)last, (String)"last");
            this.last = last;
        }

        @Nullable
        public final List<String> getBackingList() {
            return this.backingList;
        }

        public final void setBackingList(@Nullable List<String> list) {
            this.backingList = list;
        }

        private final List<String> backingList() {
            List list;
            if (this.backingList != null) {
                List<String> list2 = this.backingList;
                Intrinsics.checkNotNull(list2);
                return list2;
            }
            List lst = new ArrayList();
            PathElemBackedList pathElemBackedList = this;
            if (this.last.getParent() == null) {
                list = CollectionsKt.emptyList();
            } else {
                PathElem curr = this.last;
                PathElemBackedList pathElemBackedList2 = pathElemBackedList;
                while (curr.getParent() != null) {
                    lst.add(curr.getValue());
                    curr = curr.getParent();
                }
                pathElemBackedList = pathElemBackedList2;
                CollectionsKt.reverse((List)lst);
                list = lst;
            }
            pathElemBackedList.backingList = list;
            List<String> list3 = this.backingList;
            Intrinsics.checkNotNull(list3);
            return list3;
        }

        public int getSize() {
            return this.backingList().size();
        }

        @NotNull
        public String get(int index) {
            return this.backingList().get(index);
        }
    }
}

