/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java8.util.Objects;
import java8.util.stream.Collectors;
import java8.util.stream.StreamSupport;
import org.everit.json.schema.EnumSchema$$Lambda$1;
import org.everit.json.schema.EnumSchema$$Lambda$2;
import org.everit.json.schema.Schema;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.internal.JSONPrinter;
import org.json.JSONArray;
import org.json.JSONObject;

public class EnumSchema
extends Schema {
    private final List<Object> possibleValues;

    static Object toJavaValue(Object orig) {
        if (orig instanceof JSONArray) {
            return ((JSONArray)orig).toList();
        }
        if (orig instanceof JSONObject) {
            return ((JSONObject)orig).toMap();
        }
        if (orig == JSONObject.NULL) {
            return null;
        }
        return orig;
    }

    static List<Object> toJavaValues(List<Object> orgJsons) {
        return (List)StreamSupport.stream(orgJsons).map(EnumSchema$$Lambda$1.lambdaFactory$()).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public EnumSchema(Builder builder) {
        super(builder);
        this.possibleValues = Collections.unmodifiableList(EnumSchema.toJavaValues(builder.possibleValues));
    }

    public Set<Object> getPossibleValues() {
        return (Set)StreamSupport.stream(this.possibleValues).collect(Collectors.toSet());
    }

    public List<Object> getPossibleValuesAsList() {
        return this.possibleValues;
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        writer.key("enum");
        writer.array();
        JSONPrinter jSONPrinter = writer;
        jSONPrinter.getClass();
        this.possibleValues.forEach(EnumSchema$$Lambda$2.lambdaFactory$(jSONPrinter));
        writer.endArray();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EnumSchema) {
            EnumSchema that = (EnumSchema)o;
            return that.canEqual(this) && Objects.equals(this.possibleValues, that.possibleValues) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash((Object[])new Object[]{super.hashCode(), this.possibleValues});
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitEnumSchema(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EnumSchema;
    }

    public static class Builder
    extends Schema.Builder<EnumSchema> {
        private List<Object> possibleValues = new ArrayList<Object>();

        @Override
        public EnumSchema build() {
            return new EnumSchema(this);
        }

        public Builder possibleValue(Object possibleValue) {
            this.possibleValues.add(possibleValue);
            return this;
        }

        public Builder possibleValues(List<Object> possibleValues) {
            this.possibleValues = possibleValues;
            return this;
        }

        public Builder possibleValues(Set<Object> possibleValues) {
            this.possibleValues = (List)StreamSupport.stream(possibleValues).collect(Collectors.toList());
            return this;
        }
    }
}

