/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.List;
import java8.util.Objects;
import org.everit.json.schema.ArraySchema$$Lambda$1;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.internal.JSONPrinter;

public class ArraySchema
extends Schema {
    private final Integer minItems;
    private final Integer maxItems;
    private final boolean uniqueItems;
    private final Schema allItemSchema;
    private final boolean additionalItems;
    private final List<Schema> itemSchemas;
    private final boolean requiresArray;
    private final Schema schemaOfAdditionalItems;
    private final Schema containedItemSchema;

    public static Builder builder() {
        return new Builder();
    }

    public ArraySchema(Builder builder) {
        super(builder);
        this.minItems = builder.minItems;
        this.maxItems = builder.maxItems;
        this.uniqueItems = builder.uniqueItems;
        this.allItemSchema = builder.allItemSchema;
        this.itemSchemas = builder.itemSchemas;
        this.additionalItems = !builder.additionalItems && this.allItemSchema != null ? true : builder.schemaOfAdditionalItems != null || builder.additionalItems;
        this.schemaOfAdditionalItems = builder.schemaOfAdditionalItems;
        if (this.allItemSchema != null && this.itemSchemas != null) {
            throw new SchemaException("cannot perform both tuple and list validation");
        }
        this.requiresArray = builder.requiresArray;
        this.containedItemSchema = builder.containedItemSchema;
    }

    public Schema getAllItemSchema() {
        return this.allItemSchema;
    }

    public List<Schema> getItemSchemas() {
        return this.itemSchemas;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Schema getSchemaOfAdditionalItems() {
        return this.schemaOfAdditionalItems;
    }

    public Schema getContainedItemSchema() {
        return this.containedItemSchema;
    }

    public boolean needsUniqueItems() {
        return this.uniqueItems;
    }

    public boolean permitsAdditionalItems() {
        return this.additionalItems;
    }

    public boolean requiresArray() {
        return this.requiresArray;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ArraySchema) {
            ArraySchema that = (ArraySchema)o;
            return that.canEqual(this) && this.uniqueItems == that.uniqueItems && this.additionalItems == that.additionalItems && this.requiresArray == that.requiresArray && Objects.equals((Object)this.minItems, (Object)that.minItems) && Objects.equals((Object)this.maxItems, (Object)that.maxItems) && Objects.equals((Object)this.allItemSchema, (Object)that.allItemSchema) && Objects.equals(this.itemSchemas, that.itemSchemas) && Objects.equals((Object)this.schemaOfAdditionalItems, (Object)that.schemaOfAdditionalItems) && Objects.equals((Object)this.containedItemSchema, (Object)that.containedItemSchema) && super.equals(o);
        }
        return false;
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        if (this.requiresArray) {
            writer.key("type").value("array");
        }
        writer.ifTrue("uniqueItems", this.uniqueItems);
        writer.ifPresent("minItems", this.minItems);
        writer.ifPresent("maxItems", this.maxItems);
        writer.ifFalse("additionalItems", this.additionalItems);
        if (this.allItemSchema != null) {
            writer.key("items");
            this.allItemSchema.describeTo(writer);
        }
        if (this.itemSchemas != null) {
            writer.key("items");
            writer.array();
            this.itemSchemas.forEach(ArraySchema$$Lambda$1.lambdaFactory$(writer));
            writer.endArray();
        }
        if (this.schemaOfAdditionalItems != null) {
            writer.key("additionalItems");
            this.schemaOfAdditionalItems.describeTo(writer);
        }
        if (this.containedItemSchema != null) {
            writer.key("contains");
            this.containedItemSchema.describeTo(writer);
        }
    }

    @Override
    void accept(Visitor visitor) {
        visitor.visitArraySchema(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ArraySchema;
    }

    @Override
    public int hashCode() {
        return Objects.hash((Object[])new Object[]{super.hashCode(), this.minItems, this.maxItems, this.uniqueItems, this.allItemSchema, this.additionalItems, this.itemSchemas, this.requiresArray, this.schemaOfAdditionalItems, this.containedItemSchema});
    }

    static /* synthetic */ void lambda$describePropertiesTo$0(JSONPrinter writer, Schema schema) {
        schema.describeTo(writer);
    }

    public static class Builder
    extends Schema.Builder<ArraySchema> {
        private boolean requiresArray = true;
        private Integer minItems;
        private Integer maxItems;
        private boolean uniqueItems = false;
        private Schema allItemSchema;
        private List<Schema> itemSchemas = null;
        private boolean additionalItems = true;
        private Schema schemaOfAdditionalItems;
        private Schema containedItemSchema;

        public Builder addItemSchema(Schema itemSchema) {
            if (this.itemSchemas == null) {
                this.itemSchemas = new ArrayList<Schema>();
            }
            this.itemSchemas.add((Schema)Objects.requireNonNull((Object)itemSchema, (String)"itemSchema cannot be null"));
            return this;
        }

        public Builder additionalItems(boolean additionalItems) {
            this.additionalItems = additionalItems;
            return this;
        }

        public Builder allItemSchema(Schema allItemSchema) {
            this.allItemSchema = allItemSchema;
            return this;
        }

        @Override
        public ArraySchema build() {
            return new ArraySchema(this);
        }

        public Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public Builder minItems(Integer minItems) {
            this.minItems = minItems;
            return this;
        }

        public Builder requiresArray(boolean requiresArray) {
            this.requiresArray = requiresArray;
            return this;
        }

        public Builder schemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
            this.schemaOfAdditionalItems = schemaOfAdditionalItems;
            return this;
        }

        public Builder uniqueItems(boolean uniqueItems) {
            this.uniqueItems = uniqueItems;
            return this;
        }

        public Builder containsItemSchema(Schema contained) {
            this.containedItemSchema = contained;
            return this;
        }
    }
}

