/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.ITopic;
import org.xmind.core.internal.dom.INodeAdaptableProvider;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtils {
    private static final ErrorHandler NULL_ERROR_HANDLER = new ErrorHandler(){

        public void warning(SAXParseException exception) throws SAXException {
        }

        public void fatalError(SAXParseException exception) throws SAXException {
        }

        public void error(SAXParseException exception) throws SAXException {
        }
    };

    private DOMUtils() {
    }

    private static Transformer getDefaultTransformer() throws CoreException {
        try {
            return TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerException e) {
            throw new CoreException(15, (Throwable)e);
        }
    }

    public static DocumentBuilder getDefaultDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://apache.org/xml/features/continue-after-fatal-error", true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(NULL_ERROR_HANDLER);
        return documentBuilder;
    }

    public static String toString(Node node) {
        if (node == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(node.getNodeName());
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                sb.append(' ');
                Node item = attributes.item(i);
                sb.append(item.getNodeName());
                sb.append('=');
                sb.append('\"');
                sb.append(item.getNodeValue());
                sb.append('\"');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public static Document doCreateDocument() throws ParserConfigurationException {
        return DOMUtils.getDefaultDocumentBuilder().newDocument();
    }

    public static Document createDocument() {
        try {
            return DOMUtils.getDefaultDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            return null;
        }
    }

    public static Document createDocument(String docTag) {
        Document ret = DOMUtils.createDocument();
        DOMUtils.createElement(ret, docTag);
        return ret;
    }

    public static Document loadDocument(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        try {
            return DOMUtils.getDefaultDocumentBuilder().parse(is);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadDocument(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            Document document = DOMUtils.loadDocument(in);
            return document;
        }
        finally {
            in.close();
        }
    }

    public static void save(Node dom, OutputStream out, boolean closeOnFinish) throws IOException, CoreException {
        DOMUtils.save(DOMUtils.getDefaultTransformer(), dom, out, closeOnFinish);
    }

    public static void save(IAdaptable adaptable, OutputStream out, boolean closeOnFinish) throws IOException, CoreException {
        DOMUtils.save(DOMUtils.getDefaultTransformer(), adaptable, out, closeOnFinish);
    }

    public static void save(Transformer t, IAdaptable adaptable, OutputStream out, boolean closeOnFinish) throws IOException {
        Node dom = (Node)adaptable.getAdapter(Node.class);
        if (dom != null) {
            DOMUtils.save(t, dom, out, closeOnFinish);
        }
    }

    public static void save(Transformer t, Node dom, OutputStream out, boolean closeOnFinish) throws IOException {
        try {
            t.transform(new DOMSource(dom), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (closeOnFinish) {
                out.close();
            }
        }
    }

    public static Element createElement(Node parent, String tag) {
        Document doc = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
        Element e = doc.createElement(tag);
        parent.appendChild(e);
        return e;
    }

    public static String getPrefix(String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        if (index >= 0) {
            return qualifiedName.substring(0, index);
        }
        return null;
    }

    public static String getLocalName(String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        if (index >= 0) {
            return qualifiedName.substring(index + 1);
        }
        return qualifiedName;
    }

    public static String getQualifiedName(String prefix, String localName) {
        return prefix + ":" + localName;
    }

    public static Element createText(Node parent, String tag, String text) {
        Element e = DOMUtils.createElement(parent, tag);
        Text t = parent.getOwnerDocument().createTextNode(text);
        e.appendChild(t);
        return e;
    }

    public static Attr createAttr(Element parent, String name, Object value) {
        if (value == null) {
            return null;
        }
        Attr a = parent.getOwnerDocument().createAttribute(name);
        a.setNodeValue(value.toString());
        parent.getAttributes().setNamedItem(a);
        return a;
    }

    public static void setAttribute(Element element, String attrName, Object value) {
        if (value != null) {
            element.setAttribute(attrName, value.toString());
        } else if (element.hasAttribute(attrName)) {
            element.removeAttribute(attrName);
        }
    }

    public static String getAttribute(Element element, String attrName) {
        if (!element.hasAttribute(attrName)) {
            String localName = DOMUtils.getLocalName(attrName);
            if (!attrName.equals(localName)) {
                return DOMUtils.getAttribute(element, localName);
            }
            return null;
        }
        return element.getAttribute(attrName);
    }

    public static boolean isElementByTag(Node node, String tagName) {
        if (!(node instanceof Element)) {
            return false;
        }
        if (tagName == null) {
            return true;
        }
        Element element = (Element)node;
        String tag = element.getTagName();
        return tag.equals(tagName) || DOMUtils.getLocalName(tag).equals(DOMUtils.getLocalName(tagName));
    }

    public static Iterator<Element> childElementIter(Node parent) {
        return new ElementIterator(parent);
    }

    public static Iterator<Element> childElementIterByTag(Node parent, String tagName) {
        return new ElementIterator(parent, tagName);
    }

    public static boolean hasChildElement(Node parent) {
        return DOMUtils.childElementIter(parent).hasNext();
    }

    public static boolean hasChildElementByTag(Node parent, String tagName) {
        return DOMUtils.childElementIterByTag(parent, tagName).hasNext();
    }

    public static int getElementIndex(Node parent, String tagName, Element child) {
        Iterator<Element> it = DOMUtils.childElementIterByTag(parent, tagName);
        int i = 0;
        while (it.hasNext()) {
            if (it.next() == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getNodeIndex(Node parent, Node child) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (child != children.item(i)) continue;
            return i;
        }
        return -1;
    }

    public static Element getFirstChildElement(Node parent) {
        return DOMUtils.childElementIter(parent).next();
    }

    public static Element getFirstChildElementByTag(Node parent, String tag) {
        return DOMUtils.childElementIterByTag(parent, tag).next();
    }

    public static int getNumChildElementsByTag(Node parent, String tag) {
        int num = 0;
        Iterator<Element> it = DOMUtils.childElementIterByTag(parent, tag);
        while (it.hasNext()) {
            it.next();
            ++num;
        }
        return num;
    }

    public static Element[] getChildElementsByTag(Node parent, String tag) {
        ArrayList<Element> list = new ArrayList<Element>(parent.getChildNodes().getLength());
        Iterator<Element> it = DOMUtils.childElementIterByTag(parent, tag);
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.toArray(new Element[list.size()]);
    }

    public static Element[] getChildElements(Node parent) {
        ArrayList<Element> list = new ArrayList<Element>(parent.getChildNodes().getLength());
        Iterator<Element> it = DOMUtils.childElementIter(parent);
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.toArray(new Element[list.size()]);
    }

    public static Element ensureChildElement(Node parent, String tagName) {
        Element ele = parent.getNodeType() == 9 ? ((Document)parent).getDocumentElement() : DOMUtils.getFirstChildElementByTag(parent, tagName);
        if (ele == null) {
            ele = DOMUtils.createElement(parent, tagName);
        }
        return ele;
    }

    public static void createCentalTopicElement(Node parent, ITopic topic) {
        if (topic == null) {
            DOMUtils.createElement(parent, "topic");
        } else {
            DOMUtils.createElement(parent, topic.getTitleText());
        }
    }

    public static <T extends IAdaptable> List<T> getChildList(Element element, String childTag, INodeAdaptableProvider finder) {
        List<T> list = DOMUtils.getChildren(element, childTag, finder);
        return list;
    }

    public static <T extends IAdaptable> Set<T> getChildSet(Element element, String childTag, INodeAdaptableProvider finder) {
        List<T> list = DOMUtils.getChildren(element, childTag, finder);
        return DOMUtils.unmodifiableSet(list);
    }

    public static <T> Iterator<T> emptyIter() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    public static <T extends IAdaptable> List<T> getChildren(Element element, String childTag, INodeAdaptableProvider finder) {
        ArrayList<IAdaptable> list = new ArrayList<IAdaptable>(element.getChildNodes().getLength());
        Iterator<Element> it = DOMUtils.childElementIterByTag(element, childTag);
        while (it.hasNext()) {
            Element child = it.next();
            IAdaptable a = finder.getAdaptable(child);
            if (a == null) continue;
            list.add(a);
        }
        return list;
    }

    public static <T extends IAdaptable> List<T> getChildren(Node parent, INodeAdaptableProvider finder) {
        NodeList childNodes = parent.getChildNodes();
        int num = childNodes.getLength();
        ArrayList<IAdaptable> list = new ArrayList<IAdaptable>(num);
        for (int i = 0; i < num; ++i) {
            Node n = childNodes.item(i);
            IAdaptable a = finder.getAdaptable(n);
            if (a == null) continue;
            list.add(a);
        }
        return list;
    }

    public static <T> Set<T> unmodifiableSet(Collection<T> c) {
        return new DelegateSet<T>(c);
    }

    public static String getTextContentByTag(Node parent, String tag) {
        Element ele = DOMUtils.getFirstChildElementByTag(parent, tag);
        if (ele == null) {
            return null;
        }
        Node firstChild = ele.getFirstChild();
        return firstChild == null ? null : firstChild.getTextContent();
    }

    public static void setText(Node titleNode, String textContent) {
        Node textNode = DOMUtils.findTextNode(titleNode);
        if (textNode != null) {
            if (textContent == null) {
                titleNode.removeChild(textNode);
            } else {
                textNode.setTextContent(textContent);
            }
        } else {
            titleNode.setTextContent(textContent);
        }
    }

    public static Node findTextNode(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            if (c.getNodeType() != 3) continue;
            return c;
        }
        return null;
    }

    public static void setText(Node parent, String tag, String text) {
        Element titleElement = DOMUtils.getFirstChildElementByTag(parent, tag);
        if (titleElement == null) {
            if (text != null) {
                DOMUtils.createText(parent, tag, text);
            }
        } else {
            DOMUtils.setText(titleElement, text);
            if (!titleElement.hasChildNodes() && !titleElement.hasAttributes()) {
                parent.removeChild(titleElement);
            }
        }
    }

    public static Element addIdAttribute(Element element) {
        if (!element.hasAttribute("id")) {
            element.setAttribute("id", Core.getIdFactory().createId());
            element.setIdAttribute("id", true);
        }
        return element;
    }

    public static String replaceId(Element element) {
        String newId = Core.getIdFactory().createId();
        DOMUtils.replaceId(element, newId);
        return newId;
    }

    public static Element replaceId(Element element, String newId) {
        if (newId == null) {
            return element;
        }
        element.setAttribute("id", newId);
        element.setIdAttribute("id", true);
        return element;
    }

    public static boolean isOrphanNode(Node node) {
        if (node == null) {
            return true;
        }
        if (node.getNodeType() == 9) {
            return false;
        }
        return DOMUtils.isOrphanNode(node.getParentNode());
    }

    public static Document getOwnerDocument(Node node) {
        return node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegateSet<T>
    extends AbstractSet<T> {
        private Collection<T> c;

        public DelegateSet(Collection<T> c) {
            this.c = c;
        }

        @Override
        public Iterator<T> iterator() {
            return this.c.iterator();
        }

        @Override
        public int size() {
            return this.c.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AdaptableIterator<T extends IAdaptable>
    implements Iterator<T> {
        private Node node;
        private String tagName;
        private INodeAdaptableProvider provider;
        private boolean reversed;
        private T next;

        public AdaptableIterator(Node parent, String tagName, INodeAdaptableProvider provider, boolean reversed) {
            this.tagName = tagName;
            this.provider = provider;
            this.reversed = reversed;
            this.node = reversed ? parent.getLastChild() : parent.getFirstChild();
            this.next = this.findNext();
        }

        private T findNext() {
            while (this.node != null) {
                IAdaptable obj = DOMUtils.isElementByTag(this.node, this.tagName) ? this.provider.getAdaptable(this.node) : null;
                Node node = this.node = this.reversed ? this.node.getPreviousSibling() : this.node.getNextSibling();
                if (obj == null) continue;
                return (T)obj;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            T n = this.next;
            this.next = this.findNext();
            return n;
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementIterator
    implements Iterator<Element> {
        private String tagName;
        private Node child;
        private Element next;

        public ElementIterator(Node parent) {
            this(parent, null);
        }

        public ElementIterator(Node parent, String tagName) {
            this.tagName = tagName;
            this.child = parent.getFirstChild();
            this.next = this.findNextElement();
        }

        private Element findNextElement() {
            if (this.child == null) {
                this.next = null;
            } else {
                while (this.child != null && !DOMUtils.isElementByTag(this.child, this.tagName)) {
                    this.child = this.child.getNextSibling();
                }
                if (this.child != null) {
                    this.next = (Element)this.child;
                    this.child = this.child.getNextSibling();
                } else {
                    this.next = null;
                }
            }
            return this.next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Element next() {
            Element result = this.next;
            this.next = this.findNextElement();
            return result;
        }

        @Override
        public void remove() {
        }
    }
}

