/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.marker;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerVariation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMarkerResource
implements IMarkerResource {
    private String mainPath;
    private IMarker marker;
    private List<IMarkerVariation> variations = null;

    public AbstractMarkerResource(IMarker marker) {
        this(marker, null);
    }

    public AbstractMarkerResource(IMarker marker, String mainPath) {
        if (marker == null) {
            throw new IllegalArgumentException();
        }
        this.marker = marker;
        this.mainPath = mainPath == null ? "/" : mainPath;
    }

    protected IMarker getMarker() {
        return this.marker;
    }

    @Override
    public String getPath() {
        return this.marker.getResourcePath();
    }

    public String getFullPath() {
        String path = this.getPath();
        if (!path.startsWith("/")) {
            path = this.getMainPath() + path;
        }
        return path;
    }

    protected String getMainPath() {
        return this.mainPath;
    }

    @Override
    public synchronized List<IMarkerVariation> getVariations() {
        if (this.variations == null) {
            this.variations = new ArrayList<IMarkerVariation>();
            this.loadVariations(this.variations);
        }
        return this.variations;
    }

    protected void loadVariations(List<IMarkerVariation> variations) {
    }

    @Override
    public InputStream getInputStream(IMarkerVariation variation) {
        return this.getInputStream();
    }

    @Override
    public OutputStream getOutputStream(IMarkerVariation variation) {
        return this.getOutputStream();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractMarkerResource)) {
            return false;
        }
        AbstractMarkerResource that = (AbstractMarkerResource)obj;
        return this.marker.equals(that.marker);
    }
}

