/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xmind.core.Core;
import org.xmind.core.io.IInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryInputSource
implements IInputSource {
    private File dir;
    private FileFilter filter;

    public DirectoryInputSource(File file) {
        this(file, null);
    }

    public DirectoryInputSource(String path) {
        this(new File(path), null);
    }

    public DirectoryInputSource(File file, FileFilter filter) {
        this.dir = file;
        this.filter = filter;
    }

    public File getFile() {
        return this.dir;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public String getName() {
        return this.dir.getName();
    }

    @Override
    public Iterator<String> getEntries() {
        ArrayList<String> list = new ArrayList<String>();
        this.getSubFiles("", this.dir, list);
        return list.iterator();
    }

    private void getSubFiles(String parentEntry, File parentFile, List<String> list) {
        if (!parentFile.isDirectory()) {
            return;
        }
        for (File file : parentFile.listFiles()) {
            if (this.filter != null && !this.filter.accept(file)) continue;
            String entryName = "".equals(parentEntry) ? file.getName() : parentEntry + "/" + file.getName();
            if (!file.isDirectory()) {
                list.add(entryName);
            }
            this.getSubFiles(entryName, file, list);
        }
    }

    @Override
    public boolean isEntryAvailable(String entryName) {
        return this.isAvailable() && !new File(this.dir, entryName).isDirectory();
    }

    protected boolean isAvailable() {
        return this.dir.exists() && this.dir.isDirectory();
    }

    @Override
    public boolean hasEntry(String entryName) {
        File f = new File(this.dir, entryName);
        return f.exists() && f.canRead() && (this.filter == null || this.filter.accept(f));
    }

    @Override
    public InputStream getEntryStream(String entryName) {
        if (!this.isAvailable()) {
            return null;
        }
        File file = new File(this.dir, entryName);
        if (file.isFile() && file.canRead()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                Core.getLogger().log(e, "Failed to get entry input stream: " + entryName);
            }
        }
        return null;
    }

    @Override
    public InputStream openEntryStream(String entryName) throws IOException {
        return new FileInputStream(new File(this.dir, entryName));
    }

    public boolean closeEntryStream(String entryPath, InputStream stream) {
        try {
            stream.close();
            return true;
        }
        catch (IOException e) {
            Core.getLogger().log(e, "Failed to close entry input stream: " + entryPath);
            return false;
        }
    }

    @Override
    public long getEntrySize(String entryName) {
        File f = new File(this.dir, entryName);
        if (f.exists()) {
            return f.length();
        }
        return -1L;
    }

    @Override
    public long getEntryTime(String entryName) {
        File f = new File(this.dir, entryName);
        if (f.exists()) {
            return f.lastModified();
        }
        return -1L;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof DirectoryInputSource)) {
            return false;
        }
        DirectoryInputSource that = (DirectoryInputSource)obj;
        return this.dir.equals(that.dir) && (this.filter == that.filter || this.filter != null && this.filter.equals(that.filter));
    }

    public int hashCode() {
        return this.dir.hashCode() ^ (this.filter == null ? 1 : this.filter.hashCode());
    }
}

