/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xmind.core.Core;
import org.xmind.core.io.ICloseableOutputTarget;

public class ZipStreamOutputTarget
implements ICloseableOutputTarget {
    private static final boolean DEFAULT_COMPRESSED = Boolean.getBoolean("org.xmind.core.workbook.compressed");
    private ZipOutputStream zip;
    private Map<String, Long> timeTable = new HashMap<String, Long>();

    public ZipStreamOutputTarget(ZipOutputStream zip) {
        this(zip, DEFAULT_COMPRESSED);
    }

    public ZipStreamOutputTarget(ZipOutputStream zip, boolean compressed) {
        this.zip = zip;
        if (compressed) {
            zip.setLevel(-1);
        } else {
            zip.setLevel(0);
        }
    }

    public void setEntryTime(String entryName, long time) {
        this.timeTable.put(entryName, time);
    }

    public OutputStream getEntryStream(String entryName) {
        try {
            return this.openEntryStream(entryName);
        }
        catch (IOException e) {
            Core.getLogger().log(e);
            return null;
        }
    }

    public OutputStream openEntryStream(String entryName) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        Long time = this.timeTable.remove(entryName);
        if (time != null) {
            entry.setTime(time);
        }
        this.zip.putNextEntry(entry);
        return new ZipEntryOutputStream(this.zip);
    }

    public boolean isEntryAvaialble(String entryName) {
        return this.zip != null;
    }

    public void close() throws IOException {
        this.zip.finish();
        this.zip.flush();
        this.zip.close();
    }

    private static class ZipEntryOutputStream
    extends FilterOutputStream {
        public ZipEntryOutputStream(ZipOutputStream out) {
            super(out);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void close() throws IOException {
            this.out.flush();
            ((ZipOutputStream)this.out).closeEntry();
        }
    }
}

