/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.INotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.Notes;
import org.xmind.core.internal.dom.BaseNotesContentImpl;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

public class NotesImpl
extends Notes {
    private Element topicElement;
    private TopicImpl ownedTopic;

    public NotesImpl(Element topicElement, TopicImpl ownedTopic) {
        this.topicElement = topicElement;
        this.ownedTopic = ownedTopic;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof NotesImpl)) {
            return false;
        }
        NotesImpl that = (NotesImpl)obj;
        return this.topicElement == that.topicElement;
    }

    public int hashCode() {
        return this.topicElement.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.getNotesElement());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.getNotesElement();
        }
        return super.getAdapter(adapter);
    }

    public ITopic getParent() {
        return this.ownedTopic;
    }

    private Element getNotesElement() {
        return DOMUtils.getFirstChildElementByTag(this.topicElement, "notes");
    }

    public INotesContent getContent(String format) {
        Element c;
        Element n = this.getNotesElement();
        if (n != null && (c = DOMUtils.getFirstChildElementByTag(n, format)) != null) {
            return this.getNotesContent(c);
        }
        return null;
    }

    public boolean isEmpty() {
        Element n = this.getNotesElement();
        if (n != null) {
            return !n.hasChildNodes();
        }
        return true;
    }

    public void setContent(String format, INotesContent content) {
        Element newContentEle;
        if (format == null) {
            return;
        }
        Element notesEle = this.getNotesElement();
        Element oldContentEle = notesEle == null ? null : DOMUtils.getFirstChildElementByTag(notesEle, format);
        INotesContent oldContent = oldContentEle == null ? null : this.getNotesContent(oldContentEle);
        WorkbookImpl workbook = null;
        if (oldContent instanceof BaseNotesContentImpl) {
            if (workbook == null) {
                workbook = this.getRealizedWorkbook();
            }
            ((BaseNotesContentImpl)oldContent).removeNotify(workbook);
        }
        if (oldContentEle != null && notesEle != null) {
            notesEle.removeChild(oldContentEle);
        }
        if (content != null && (newContentEle = (Element)content.getAdapter(Element.class)) != null) {
            if (notesEle == null) {
                notesEle = DOMUtils.ensureChildElement(this.topicElement, "notes");
            }
            notesEle.appendChild(newContentEle);
        }
        if (notesEle != null && !notesEle.hasChildNodes()) {
            this.topicElement.removeChild(notesEle);
        }
        if (content instanceof BaseNotesContentImpl) {
            if (workbook == null) {
                workbook = this.getRealizedWorkbook();
            }
            ((BaseNotesContentImpl)content).addNotify(workbook);
        }
        this.fireTargetValueChange(format, oldContent, content);
        this.ownedTopic.updateModifiedTime();
    }

    private INotesContent getNotesContent(Element oldContentEle) {
        return (INotesContent)((WorkbookImpl)this.getOwnedWorkbook()).getAdaptableRegistry().getAdaptable(oldContentEle);
    }

    protected WorkbookImpl getRealizedWorkbook() {
        ITopic parent = this.getParent();
        if (parent instanceof TopicImpl) {
            return ((TopicImpl)parent).getRealizedWorkbook();
        }
        return null;
    }

    protected void addNotify(WorkbookImpl workbook) {
        Element n = this.getNotesElement();
        if (n != null) {
            Iterator<Element> it = DOMUtils.childElementIter(n);
            while (it.hasNext()) {
                Element c = it.next();
                INotesContent content = this.getNotesContent(c);
                if (!(content instanceof BaseNotesContentImpl)) continue;
                ((BaseNotesContentImpl)content).addNotify(workbook);
            }
        }
    }

    protected void removeNotify(WorkbookImpl workbook) {
        Element n = this.getNotesElement();
        if (n != null) {
            Iterator<Element> it = DOMUtils.childElementIter(n);
            while (it.hasNext()) {
                Element c = it.next();
                INotesContent content = this.getNotesContent(c);
                if (!(content instanceof BaseNotesContentImpl)) continue;
                ((BaseNotesContentImpl)content).removeNotify(workbook);
            }
        }
    }

    private void fireTargetValueChange(Object target, Object oldValue, Object newValue) {
        this.ownedTopic.getCoreEventSupport().dispatchTargetValueChange(this.ownedTopic, "topicNotes", target, oldValue, newValue);
    }

    public ISheet getOwnedSheet() {
        return this.ownedTopic.getOwnedSheet();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownedTopic.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.ownedTopic.isOrphan();
    }
}

