/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.SimplePermutationGenerator;

class SimplePermutationIterator<T>
implements Iterator<List<T>> {
    private final SimplePermutationGenerator<T> generator;
    private final List<T> currentPermutation;
    private final int length;
    private long currentIndex = 0L;
    private int[] pZ = null;
    private int[] pP = null;
    private int[] pD = null;
    private int m = 0;
    private int w = 0;
    private int pm = 0;
    private int dm = 0;
    private int zpm = 0;

    SimplePermutationIterator(SimplePermutationGenerator<T> generator) {
        this.generator = generator;
        this.length = generator.originalVector.size();
        this.currentPermutation = new ArrayList(generator.originalVector);
        this.pZ = new int[this.length + 2];
        this.pP = new int[this.length + 2];
        this.pD = new int[this.length + 2];
        this.currentIndex = 0L;
        this.m = 0;
        this.w = 0;
        this.pm = 0;
        this.dm = 0;
        this.zpm = 0;
        for (int i = 1; i <= this.length; ++i) {
            this.pP[i] = i;
            this.pZ[i] = i;
            this.pD[i] = -1;
        }
        this.pD[1] = 0;
        this.pZ[this.length + 1] = this.m = this.length + 1;
        this.pZ[0] = this.pZ[this.length + 1];
    }

    @Override
    public boolean hasNext() {
        return this.m != 1;
    }

    @Override
    public List<T> next() {
        for (int i = 1; i <= this.length; ++i) {
            int index = this.pZ[i] - 1;
            this.currentPermutation.set(i - 1, this.generator.originalVector.get(index));
        }
        this.m = this.length;
        while (this.pZ[this.pP[this.m] + this.pD[this.m]] > this.m) {
            this.pD[this.m] = -this.pD[this.m];
            --this.m;
        }
        this.pm = this.pP[this.m];
        this.dm = this.pm + this.pD[this.m];
        this.w = this.pZ[this.pm];
        this.pZ[this.pm] = this.pZ[this.dm];
        this.pZ[this.dm] = this.w;
        this.zpm = this.pZ[this.pm];
        this.w = this.pP[this.zpm];
        this.pP[this.zpm] = this.pm;
        this.pP[this.m] = this.w;
        ++this.currentIndex;
        return new ArrayList<T>(this.currentPermutation);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SimplePermutationIterator=[#" + this.currentIndex + ", " + this.currentPermutation + "]";
    }
}

