/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.paukov.combinatorics3.IGenerator;
import org.paukov.combinatorics3.PermutationWithRepetitionGenerator;
import org.paukov.combinatorics3.SimplePermutationGenerator;

public class PermutationGenerator<T> {
    final Collection<T> originalVector;

    public static <T> boolean hasDuplicates(Collection<T> collection) {
        if (collection.size() <= 1) {
            return false;
        }
        HashSet<T> set = new HashSet<T>(collection);
        return set.size() < collection.size();
    }

    PermutationGenerator(Collection<T> originalVector) {
        this.originalVector = originalVector;
    }

    public IGenerator<List<T>> simple() {
        return new SimplePermutationGenerator<T>(this.originalVector, false);
    }

    public IGenerator<List<T>> simple(TreatDuplicatesAs treatAsIdentical) {
        return new SimplePermutationGenerator<T>(this.originalVector, TreatDuplicatesAs.IDENTICAL.equals((Object)treatAsIdentical));
    }

    public IGenerator<List<T>> withRepetitions(int permutationLength) {
        return new PermutationWithRepetitionGenerator<T>(this.originalVector, permutationLength);
    }

    public static enum TreatDuplicatesAs {
        DIFFERENT,
        IDENTICAL;

    }
}

