/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.IntegerPartitionGenerator;

class IntegerPartitionIterator
implements Iterator<List<Integer>> {
    private final InternalVector mVector;
    private final InternalVector zVector;
    private List<Integer> currentPartition = null;
    private long currentIndex = 0L;
    private int stopIndex = 1;

    IntegerPartitionIterator(IntegerPartitionGenerator generator) {
        int partitionValue = generator.value;
        if (partitionValue > 0) {
            this.currentIndex = 0L;
            this.stopIndex = 1;
            this.mVector = new InternalVector(partitionValue, 0, 0, partitionValue);
            this.zVector = new InternalVector(partitionValue, 0, partitionValue + 1, 1);
        } else {
            this.stopIndex = 0;
            this.mVector = new InternalVector(1, 0, 0, 0);
            this.zVector = new InternalVector(1, 0, 0, 0);
        }
    }

    @Override
    public boolean hasNext() {
        return this.stopIndex != 0;
    }

    @Override
    public List<Integer> next() {
        ++this.currentIndex;
        this.currentPartition = IntegerPartitionIterator.createCurrentPartition(this.stopIndex, this.mVector, this.zVector);
        int sum = this.mVector.get(this.stopIndex) * this.zVector.get(this.stopIndex);
        if (this.mVector.get(this.stopIndex) == 1) {
            --this.stopIndex;
            sum += this.mVector.get(this.stopIndex) * this.zVector.get(this.stopIndex);
        }
        if (this.zVector.get(this.stopIndex - 1) == this.zVector.get(this.stopIndex) + 1) {
            --this.stopIndex;
            this.mVector.set(this.stopIndex, this.mVector.get(this.stopIndex) + 1);
        } else {
            this.zVector.set(this.stopIndex, this.zVector.get(this.stopIndex) + 1);
            this.mVector.set(this.stopIndex, 1);
        }
        if (sum > this.zVector.get(this.stopIndex)) {
            this.zVector.set(this.stopIndex + 1, 1);
            this.mVector.set(this.stopIndex + 1, sum - this.zVector.get(this.stopIndex));
            ++this.stopIndex;
        }
        return this.currentPartition;
    }

    private static List<Integer> createCurrentPartition(int k, InternalVector mVector, InternalVector zVector) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int index = 1; index <= k; ++index) {
            for (int j = 0; j < mVector.get(index); ++j) {
                list.add(zVector.get(index));
            }
        }
        return list;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "IntegerPartitionIterator=[#" + this.currentIndex + ", " + this.currentPartition + "]";
    }

    private class InternalVector {
        final int[] internalVector;

        InternalVector(int size, int value0, int value1, int value2) {
            this.internalVector = new int[size + 2];
            this.internalVector[0] = value0;
            this.internalVector[1] = value1;
            this.internalVector[2] = value2;
        }

        int get(int index) {
            return this.internalVector[index + 1];
        }

        void set(int index, int value) {
            this.internalVector[index + 1] = value;
        }
    }
}

