/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.springboot.autoconfigure;

import com.github.dozermapper.spring.DozerBeanMapperFactoryBean;
import com.github.dozermapper.springboot.autoconfigure.DozerConfigurationProperties;
import java.io.IOException;
import org.dozer.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DozerBeanMapperFactoryBean.class, Mapper.class})
@ConditionalOnMissingBean(value={Mapper.class})
@EnableConfigurationProperties(value={DozerConfigurationProperties.class})
public class DozerAutoConfiguration {
    private final DozerConfigurationProperties configurationProperties;

    @Autowired
    public DozerAutoConfiguration(DozerConfigurationProperties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    @Bean
    public DozerBeanMapperFactoryBean dozerMapper() throws IOException {
        DozerBeanMapperFactoryBean factoryBean = new DozerBeanMapperFactoryBean();
        factoryBean.setMappingFiles(this.configurationProperties.getMappingFiles());
        return factoryBean;
    }
}

