/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.command.ListServicesCmd;
import com.github.dockerjava.api.model.Service;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.util.FiltersEncoder;
import com.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;
import com.google.common.net.UrlEscapers;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListServicesCmdExec
extends AbstrSyncDockerCmdExec<ListServicesCmd, List<Service>>
implements ListServicesCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListServicesCmdExec.class);

    public ListServicesCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Service> execute(ListServicesCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/services");
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", new Object[]{UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode((Map)command.getFilters()))});
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List services = (List)webTarget.request().accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Service>>(){});
        LOGGER.trace("Response: {}", (Object)services);
        return services;
    }
}

