/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.pattern.DefinitionPatternMatcher;
import org.apache.tiles.definition.pattern.PatternDefinitionResolver;

public abstract class AbstractPatternDefinitionResolver<T>
implements PatternDefinitionResolver<T> {
    private Map<T, List<DefinitionPatternMatcher>> localePatternPaths = new HashMap<T, List<DefinitionPatternMatcher>>();

    @Override
    public Definition resolveDefinition(String name, T customizationKey) {
        Definition retValue = null;
        if (this.localePatternPaths.containsKey(customizationKey)) {
            retValue = this.searchAndResolveDefinition(this.localePatternPaths.get(customizationKey), name);
        }
        return retValue;
    }

    @Override
    public Map<String, Definition> storeDefinitionPatterns(Map<String, Definition> localeDefsMap, T customizationKey) {
        List<DefinitionPatternMatcher> lpaths = this.localePatternPaths.get(customizationKey);
        if (lpaths == null) {
            lpaths = new ArrayList<DefinitionPatternMatcher>();
            this.localePatternPaths.put(customizationKey, lpaths);
        }
        return this.addDefinitionsAsPatternMatchers(lpaths, localeDefsMap);
    }

    protected abstract Map<String, Definition> addDefinitionsAsPatternMatchers(List<DefinitionPatternMatcher> var1, Map<String, Definition> var2);

    private Definition searchAndResolveDefinition(List<DefinitionPatternMatcher> paths, String name) {
        DefinitionPatternMatcher wm;
        Definition d = null;
        Iterator<DefinitionPatternMatcher> i$ = paths.iterator();
        while (i$.hasNext() && (d = (wm = i$.next()).createDefinition(name)) == null) {
        }
        return d;
    }

    @Override
    public void clearPatternPaths(T customizationKey) {
        if (this.localePatternPaths.get(customizationKey) != null) {
            this.localePatternPaths.get(customizationKey).clear();
        }
    }
}

