/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.SQLDialect;

enum Term {
    ARRAY_AGG{

        @Override
        public String translate(SQLDialect dialect) {
            return "array_agg";
        }
    }
    ,
    ATAN2{

        @Override
        public String translate(SQLDialect dialect) {
            return "atan2";
        }
    }
    ,
    BIT_LENGTH{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case DERBY: 
                case SQLITE: {
                    return "8 * length";
                }
            }
            return "bit_length";
        }
    }
    ,
    CHAR_LENGTH{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case DERBY: 
                case SQLITE: {
                    return "length";
                }
            }
            return "char_length";
        }
    }
    ,
    LIST_AGG{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case SQLITE: 
                case CUBRID: 
                case H2: 
                case HSQLDB: 
                case MARIADB: 
                case MYSQL: {
                    return "group_concat";
                }
                case POSTGRES: {
                    return "string_agg";
                }
            }
            return "listagg";
        }
    }
    ,
    MEDIAN{

        @Override
        public String translate(SQLDialect dialect) {
            return "median";
        }
    }
    ,
    OCTET_LENGTH{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case DERBY: 
                case SQLITE: {
                    return "length";
                }
            }
            return "octet_length";
        }
    }
    ,
    ROW_NUMBER{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case HSQLDB: {
                    return "rownum";
                }
            }
            return "row_number";
        }
    }
    ,
    STDDEV_POP{

        @Override
        public String translate(SQLDialect dialect) {
            return "stddev_pop";
        }
    }
    ,
    STDDEV_SAMP{

        @Override
        public String translate(SQLDialect dialect) {
            return "stddev_samp";
        }
    }
    ,
    VAR_POP{

        @Override
        public String translate(SQLDialect dialect) {
            return "var_pop";
        }
    }
    ,
    VAR_SAMP{

        @Override
        public String translate(SQLDialect dialect) {
            return "var_samp";
        }
    };


    abstract String translate(SQLDialect var1);
}

