/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.QueryPart;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.Utils;

class QueryPartList<T extends QueryPart>
extends AbstractQueryPart
implements List<T> {
    private static final long serialVersionUID = -2936922742534009564L;
    private final List<T> wrappedList = new ArrayList<T>();

    QueryPartList() {
        this((Collection)null);
    }

    QueryPartList(Collection<? extends T> wrappedList) {
        if (wrappedList != null && !wrappedList.isEmpty()) {
            this.addAll((Collection<? extends T>)wrappedList);
        }
    }

    QueryPartList(T ... wrappedList) {
        this((Collection<T>)Arrays.asList(wrappedList));
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.isEmpty()) {
            this.toSQLEmptyList(ctx);
        } else {
            boolean indent;
            String separator = "";
            boolean bl = indent = this.size() > 1 && ctx.data((Object)Utils.DataKey.DATA_LIST_ALREADY_INDENTED) == null;
            if (indent) {
                ctx.formatIndentStart();
            }
            for (int i = 0; i < this.size(); ++i) {
                ctx.sql(separator);
                if (i > 0 || indent) {
                    ctx.formatNewLine();
                }
                ctx.visit((QueryPart)this.get(i));
                separator = ", ";
            }
            if (indent) {
                ctx.formatIndentEnd();
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    protected void toSQLEmptyList(Context<?> context) {
    }

    @Override
    public final int size() {
        return this.wrappedList.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.wrappedList.isEmpty();
    }

    @Override
    public final boolean contains(Object o) {
        return this.wrappedList.contains(o);
    }

    @Override
    public final Iterator<T> iterator() {
        return this.wrappedList.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.wrappedList.toArray();
    }

    @Override
    public final <E> E[] toArray(E[] a) {
        return this.wrappedList.toArray(a);
    }

    @Override
    public final boolean add(T e) {
        if (e != null) {
            return this.wrappedList.add(e);
        }
        return false;
    }

    @Override
    public final boolean remove(Object o) {
        return this.wrappedList.remove(o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.wrappedList.containsAll(c);
    }

    @Override
    public final boolean addAll(Collection<? extends T> c) {
        return this.wrappedList.addAll(this.removeNulls(c));
    }

    @Override
    public final boolean addAll(int index, Collection<? extends T> c) {
        return this.wrappedList.addAll(index, this.removeNulls(c));
    }

    private final Collection<? extends T> removeNulls(Collection<? extends T> c) {
        if (c.contains(null)) {
            ArrayList<T> list = new ArrayList<T>(c);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
            return list;
        }
        return c;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        return this.wrappedList.removeAll(c);
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        return this.wrappedList.retainAll(c);
    }

    @Override
    public final void clear() {
        this.wrappedList.clear();
    }

    @Override
    public final T get(int index) {
        return (T)((QueryPart)this.wrappedList.get(index));
    }

    @Override
    public final T set(int index, T element) {
        if (element != null) {
            return (T)((QueryPart)this.wrappedList.set(index, element));
        }
        return null;
    }

    @Override
    public final void add(int index, T element) {
        if (element != null) {
            this.wrappedList.add(index, element);
        }
    }

    @Override
    public final T remove(int index) {
        return (T)((QueryPart)this.wrappedList.remove(index));
    }

    @Override
    public final int indexOf(Object o) {
        return this.wrappedList.indexOf(o);
    }

    @Override
    public final int lastIndexOf(Object o) {
        return this.wrappedList.lastIndexOf(o);
    }

    @Override
    public final ListIterator<T> listIterator() {
        return this.wrappedList.listIterator();
    }

    @Override
    public final ListIterator<T> listIterator(int index) {
        return this.wrappedList.listIterator(index);
    }

    @Override
    public final List<T> subList(int fromIndex, int toIndex) {
        return this.wrappedList.subList(fromIndex, toIndex);
    }
}

