/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.CreateTableAsStep;
import org.jooq.CreateTableColumnStep;
import org.jooq.CreateTableFinalStep;
import org.jooq.CreateTableOnCommitStep;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.Utils;

class CreateTableImpl<R extends Record>
extends AbstractQuery
implements CreateTableAsStep<R>,
CreateTableColumnStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private final Table<?> table;
    private Select<?> select;
    private final List<Field<?>> columnFields;
    private final List<DataType<?>> columnTypes;
    private final boolean temporary;
    private OnCommit onCommit;

    CreateTableImpl(Configuration configuration, Table<?> table, boolean temporary) {
        super(configuration);
        this.table = table;
        this.temporary = temporary;
        this.columnFields = new ArrayList();
        this.columnTypes = new ArrayList();
    }

    @Override
    public final CreateTableOnCommitStep as(Select<? extends R> s) {
        this.select = s;
        return this;
    }

    @Override
    public final <T> CreateTableColumnStep column(Field<T> field, DataType<T> type) {
        this.columnFields.add(field);
        this.columnTypes.add(type);
        return this;
    }

    @Override
    public final CreateTableColumnStep column(String field, DataType<?> type) {
        this.columnFields.add(DSL.field(DSL.name(field), type));
        this.columnTypes.add(type);
        return this;
    }

    @Override
    public final CreateTableFinalStep onCommitDeleteRows() {
        this.onCommit = OnCommit.DELETE_ROWS;
        return this;
    }

    @Override
    public final CreateTableFinalStep onCommitPreserveRows() {
        this.onCommit = OnCommit.PRESERVE_ROWS;
        return this;
    }

    @Override
    public final CreateTableFinalStep onCommitDrop() {
        this.onCommit = OnCommit.DROP;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.select != null) {
            this.acceptCreateTableAsSelect(ctx);
        } else {
            ctx.start(Clause.CREATE_TABLE);
            this.toSQLCreateTableName(ctx);
            ctx.start(Clause.CREATE_TABLE_COLUMNS).sql('(').formatIndentStart().formatNewLine();
            boolean qualify = ctx.qualify();
            ctx.qualify(false);
            for (int i = 0; i < this.columnFields.size(); ++i) {
                DataType<?> type = this.columnTypes.get(i);
                ctx.visit(this.columnFields.get(i)).sql(' ');
                Utils.toSQLDDLTypeDeclaration(ctx, type);
                if (type.nullable()) {
                    if (!Arrays.asList(SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)ctx.family())) {
                        ctx.sql(' ').keyword("null");
                    }
                } else {
                    ctx.sql(' ').keyword("not null");
                }
                if (i >= this.columnFields.size() - 1) continue;
                ctx.sql(',').formatSeparator();
            }
            ctx.qualify(qualify);
            ctx.formatIndentEnd().formatNewLine().sql(')').end(Clause.CREATE_TABLE_COLUMNS);
            this.toSQLOnCommit(ctx);
            ctx.end(Clause.CREATE_TABLE);
        }
    }

    private final void acceptCreateTableAsSelect(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE);
        this.toSQLCreateTableName(ctx);
        this.toSQLOnCommit(ctx);
        ctx.formatSeparator().keyword("as");
        ctx.formatSeparator();
        ctx.start(Clause.CREATE_TABLE_AS).visit(this.select).end(Clause.CREATE_TABLE_AS);
        ctx.end(Clause.CREATE_TABLE);
    }

    private final void toSQLCreateTableName(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE_NAME).keyword("create").sql(' ');
        if (this.temporary) {
            if (Arrays.asList(SQLDialect.POSTGRES).contains((Object)ctx.family())) {
                ctx.keyword("temporary").sql(' ');
            } else {
                ctx.keyword("global temporary").sql(' ');
            }
        }
        ctx.keyword("table").sql(' ').visit(this.table).end(Clause.CREATE_TABLE_NAME);
    }

    private final void toSQLOnCommit(Context<?> ctx) {
        if (this.temporary && this.onCommit != null) {
            switch (this.onCommit) {
                case DELETE_ROWS: {
                    ctx.formatSeparator().keyword("on commit delete rows");
                    break;
                }
                case PRESERVE_ROWS: {
                    ctx.formatSeparator().keyword("on commit preserve rows");
                    break;
                }
                case DROP: {
                    ctx.formatSeparator().keyword("on commit drop");
                }
            }
        }
    }

    private final void acceptSelectInto(Context<?> ctx) {
        ctx.data((Object)Utils.DataKey.DATA_SELECT_INTO_TABLE, this.table);
        ctx.visit(this.select);
        ctx.data().remove((Object)Utils.DataKey.DATA_SELECT_INTO_TABLE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private static enum OnCommit {
        DELETE_ROWS,
        PRESERVE_ROWS,
        DROP;

    }
}

