/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.servlet.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

public class BHiveJSPRequestLoggingFilter
implements Filter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block4: {
            try {
                ServletResponse responseWrapper = response;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\r\n\t##################################################\r\n\t#### START JSP - " + this.getServletPathName(request) + "\r\n\t\trequest parameter: " + BHiveJSPRequestLoggingFilter.getLoggableRequestMap(request));
                }
                chain.doFilter(request, response);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\r\n\t#### END JSP - " + this.getServletPathName(request) + "\r\n\t##################################################" + this.getLoggableResponseBody(responseWrapper));
                }
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.error("{} FAILED.\r\nex message: {}", new Object[]{this.getServletPathName(request), ex.toString(), ex});
            }
        }
    }

    private String getServletPathName(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            return httpRequest.getServletPath();
        }
        return request.toString();
    }

    private String getLoggableResponseBody(ServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        String contentType = response.getContentType();
        map.put("contentType", contentType);
        HttpServletResponse httpRequest = (HttpServletResponse)WebUtils.getNativeResponse((ServletResponse)response, HttpServletResponse.class);
        if (httpRequest != null) {
            int status = httpRequest.getStatus();
            map.put("StatusCode", String.valueOf(status));
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry item : map.entrySet()) {
            sb.append("\r\n\t\t- " + (String)item.getKey() + ": " + (String)item.getValue());
        }
        return sb.toString();
    }

    public static Map<String, String> getLoggableRequestMap(ServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map parameterMap = request.getParameterMap();
        for (Map.Entry item : parameterMap.entrySet()) {
            String key = (String)item.getKey();
            String[] value = (String[])item.getValue();
            result.put(key, Arrays.asList(value).toString());
        }
        return result;
    }
}

