/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.util;

import blue.hive.annotation.Display;
import blue.hive.annotation.ExcelColumn;
import blue.hive.exception.BHiveRuntimeException;
import blue.hive.util.BHiveCollectionUtil;
import blue.hive.util.BHiveDateUtil;
import blue.hive.util.anyframe.StringUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class BHiveVOUtil {
    protected static Logger logger = LoggerFactory.getLogger(BHiveVOUtil.class);

    public static Map<String, Integer> getDisplayOrderMap(Class<?> voClass) {
        Field[] fields = voClass.getDeclaredFields();
        HashMap<String, Integer> voFieldOrderMap = new HashMap();
        for (Field field : fields) {
            String fieldName = field.getName();
            int displayOrder = Integer.MAX_VALUE;
            Display displayAnnotation = field.getAnnotation(Display.class);
            if (displayAnnotation != null) {
                displayOrder = displayAnnotation.order();
            }
            voFieldOrderMap.put(fieldName, displayOrder);
        }
        voFieldOrderMap = BHiveCollectionUtil.sortByValues(voFieldOrderMap);
        return voFieldOrderMap;
    }

    public static Map<String, String> getDisplayNameMap(Class<?> voClass) {
        return BHiveVOUtil.getDisplayNameMap(voClass, null, null, Locale.getDefault());
    }

    public static Map<String, String> getDisplayNameMap(Class<?> voClass, MessageSource messageSource, String prefix, Locale locale) {
        Field[] fields = voClass.getDeclaredFields();
        HashMap<String, String> voFieldNameMap = new HashMap<String, String>();
        for (Field field : fields) {
            String fieldName = field.getName();
            String displayName = null;
            Display displayAnnotation = field.getAnnotation(Display.class);
            if (displayAnnotation != null) {
                displayName = displayAnnotation.name();
            } else {
                displayName = fieldName;
                if (StringUtil.isNotEmpty(prefix)) {
                    displayName = prefix + displayName;
                }
                displayName = displayName.toLowerCase();
            }
            if (messageSource != null) {
                displayName = messageSource.getMessage(displayName, null, locale);
            }
            voFieldNameMap.put(fieldName, displayName);
        }
        return voFieldNameMap;
    }

    public static String getDisplayName(Class<?> voClass, String declaredFieldName) {
        return BHiveVOUtil.getDisplayName(voClass, declaredFieldName, null, null, Locale.getDefault());
    }

    public static String getDisplayName(Class<?> voClass, String declaredFieldName, MessageSource messageSource, String prefix, Locale locale) {
        Field field;
        try {
            field = voClass.getDeclaredField(declaredFieldName);
        }
        catch (Exception e) {
            throw new BHiveRuntimeException("Failed to get declared field.", e);
        }
        String fieldName = field.getName();
        String displayName = null;
        Display displayAnnotation = field.getAnnotation(Display.class);
        if (displayAnnotation != null) {
            displayName = displayAnnotation.name();
        } else {
            displayName = fieldName;
            if (StringUtil.isNotEmpty(prefix)) {
                displayName = prefix + displayName;
            }
        }
        if (messageSource != null) {
            displayName = messageSource.getMessage(displayName, null, locale);
        }
        return displayName;
    }

    public static void setVOProperties(Object voClass, Map<String, Object> map) {
        try {
            for (Field field : voClass.getClass().getDeclaredFields()) {
                if (field.getType().equals(DateTime.class)) {
                    field.set(voClass, BHiveDateUtil.parseToDateTime(map.get(field.getName().toString()).toString()));
                    continue;
                }
                if (field.getType().equals(Integer.class)) {
                    field.set(voClass, map.get(field.getName()));
                    continue;
                }
                field.set(voClass, map.get(field.getName().toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ExcelColumn getExcelColumnAnnotation(Class<?> voClass, PropertyDescriptor descriptor) {
        String propName = descriptor.getName();
        ExcelColumn annotation = null;
        try {
            Field field = voClass.getDeclaredField(propName);
            annotation = field.getAnnotation(ExcelColumn.class);
            if (annotation != null) {
                return annotation;
            }
        }
        catch (SecurityException field) {
        }
        catch (NoSuchFieldException field) {
            // empty catch block
        }
        Method method = PropertyUtils.getReadMethod((PropertyDescriptor)descriptor);
        if (method != null && (annotation = method.getAnnotation(ExcelColumn.class)) != null) {
            return annotation;
        }
        return null;
    }

    public static Map<String, Integer> getExcelColumnOrderMap(Class<?> voClass) {
        PropertyDescriptor[] descriptors;
        HashMap<String, Integer> voFieldOrderMap = new HashMap();
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors(voClass)) {
            ExcelColumn excelColumnAnnotation = BHiveVOUtil.getExcelColumnAnnotation(voClass, descriptor);
            if (excelColumnAnnotation == null || excelColumnAnnotation.ignore()) continue;
            String columnName = descriptor.getName();
            int excelColumnOrder = Integer.MAX_VALUE;
            excelColumnOrder = excelColumnAnnotation.order();
            voFieldOrderMap.put(columnName, excelColumnOrder);
        }
        voFieldOrderMap = BHiveCollectionUtil.sortByValues(voFieldOrderMap);
        return voFieldOrderMap;
    }

    public static Map<String, String> getExcelColumnGroupNameMap(Class<?> voClass) {
        return BHiveVOUtil.getExcelColumnGroupNameMap(voClass, null, null, Locale.getDefault());
    }

    public static Map<String, String> getExcelColumnGroupNameMap(Class<?> voClass, MessageSource messageSource, String prefix, Locale locale) {
        PropertyDescriptor[] descriptors;
        HashMap<String, String> voFieldNameMap = new HashMap<String, String>();
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors(voClass)) {
            ExcelColumn excelColumnAnnotation = BHiveVOUtil.getExcelColumnAnnotation(voClass, descriptor);
            if (excelColumnAnnotation == null || excelColumnAnnotation.ignore()) continue;
            String columnName = descriptor.getName();
            String excelColumnName = null;
            excelColumnName = excelColumnAnnotation.groupname();
            if (excelColumnName == null) {
                excelColumnName = columnName;
                if (StringUtil.isNotEmpty(prefix)) {
                    excelColumnName = prefix + excelColumnName;
                }
                excelColumnName = excelColumnName.toLowerCase();
            }
            if (messageSource != null) {
                excelColumnName = messageSource.getMessage(excelColumnName, null, locale);
            }
            voFieldNameMap.put(columnName, excelColumnName);
        }
        return voFieldNameMap;
    }

    public static Map<String, String> getExcelColumnNameMap(Class<?> voClass) {
        return BHiveVOUtil.getExcelColumnNameMap(voClass, null, null, Locale.getDefault());
    }

    public static Map<String, String> getExcelColumnNameMap(Class<?> voClass, MessageSource messageSource, String prefix, Locale locale) {
        PropertyDescriptor[] descriptors;
        HashMap<String, String> voFieldNameMap = new HashMap<String, String>();
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors(voClass)) {
            ExcelColumn excelColumnAnnotation = BHiveVOUtil.getExcelColumnAnnotation(voClass, descriptor);
            if (excelColumnAnnotation == null || excelColumnAnnotation.ignore()) continue;
            String columnName = descriptor.getName();
            String excelColumnName = null;
            excelColumnName = excelColumnAnnotation.name();
            if (StringUtil.isEmpty(excelColumnName)) {
                excelColumnName = columnName;
                if (StringUtil.isNotEmpty(prefix)) {
                    excelColumnName = prefix + excelColumnName;
                }
                excelColumnName = excelColumnName.toLowerCase();
            }
            if (messageSource != null) {
                excelColumnName = messageSource.getMessage(excelColumnName, null, locale);
            }
            voFieldNameMap.put(columnName, excelColumnName);
        }
        return voFieldNameMap;
    }

    public static Map<String, ExcelColumn> getExcelColumnAnnotationMap(Class<?> voClass) {
        PropertyDescriptor[] descriptors;
        HashMap<String, ExcelColumn> voFieldOrderMap = new HashMap<String, ExcelColumn>();
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors(voClass)) {
            ExcelColumn excelColumnAnnotation = BHiveVOUtil.getExcelColumnAnnotation(voClass, descriptor);
            if (excelColumnAnnotation == null || excelColumnAnnotation.ignore()) continue;
            String columnName = descriptor.getName();
            voFieldOrderMap.put(columnName, excelColumnAnnotation);
        }
        return voFieldOrderMap;
    }
}

