/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WildcardHelper {
    protected static final int MATCH_FILE = -1;
    protected static final int MATCH_PATH = -2;
    protected static final int MATCH_BEGIN = -4;
    protected static final int MATCH_THEEND = -5;
    protected static final int MATCH_END = -3;
    private static final int PLACEHOLDER_LENGTH = 3;

    public int[] compilePattern(String data) {
        int[] expr = new int[data.length() + 2];
        char[] buff = data.toCharArray();
        int y = 0;
        boolean slash = false;
        expr[y++] = -4;
        if (buff.length > 0) {
            if (buff[0] == '\\') {
                slash = true;
            } else {
                expr[y++] = buff[0] == '*' ? -1 : buff[0];
            }
            for (int x = 1; x < buff.length; ++x) {
                if (slash) {
                    expr[y++] = buff[x];
                    slash = false;
                    continue;
                }
                if (buff[x] == '\\') {
                    slash = true;
                    continue;
                }
                if (buff[x] == '*') {
                    if (expr[y - 1] <= -1) {
                        expr[y - 1] = -2;
                        continue;
                    }
                    expr[y++] = -1;
                    continue;
                }
                expr[y++] = buff[x];
            }
        }
        expr[y] = -5;
        return expr;
    }

    public List<String> match(String data, int[] expr) {
        List<String> varsValues = null;
        if (data == null) {
            throw new NullPointerException("No data provided");
        }
        if (expr == null) {
            throw new NullPointerException("No pattern expression provided");
        }
        char[] buff = data.toCharArray();
        char[] rslt = new char[expr.length + buff.length];
        int charpos = 0;
        int exprpos = 0;
        int buffpos = 0;
        int rsltpos = 0;
        int offset = -1;
        boolean matchBegin = false;
        if (expr[charpos] == -4) {
            matchBegin = true;
            exprpos = ++charpos;
        }
        while (expr[charpos] >= 0) {
            ++charpos;
        }
        int exprchr = expr[charpos];
        while (true) {
            if (matchBegin) {
                if (!this.matchArray(expr, exprpos, charpos, buff, buffpos)) {
                    return null;
                }
                matchBegin = false;
            } else {
                offset = this.indexOfArray(expr, exprpos, charpos, buff, buffpos);
                if (offset < 0) {
                    return null;
                }
            }
            if (matchBegin) {
                if (offset != 0) {
                    return null;
                }
                matchBegin = false;
            }
            buffpos += charpos - exprpos;
            if (exprchr == -3) {
                if (rsltpos > 0) {
                    varsValues = this.addAndCreateList(varsValues, new String(rslt, 0, rsltpos));
                }
                varsValues = this.addElementOnTop(varsValues, data);
                return varsValues;
            }
            if (exprchr == -5) {
                if (rsltpos > 0) {
                    varsValues = this.addAndCreateList(varsValues, new String(rslt, 0, rsltpos));
                }
                if (buffpos == buff.length) {
                    this.addElementOnTop(varsValues, data);
                    return varsValues;
                }
                return null;
            }
            exprpos = ++charpos;
            while (expr[charpos] >= 0) {
                ++charpos;
            }
            int prevchr = exprchr;
            exprchr = expr[charpos];
            int n = offset = prevchr == -1 ? this.indexOfArray(expr, exprpos, charpos, buff, buffpos) : this.lastIndexOfArray(expr, exprpos, charpos, buff, buffpos);
            if (offset < 0) {
                return null;
            }
            if (prevchr == -2) {
                while (buffpos < offset) {
                    rslt[rsltpos++] = buff[buffpos++];
                }
            } else {
                while (buffpos < offset) {
                    if (buff[buffpos] == '/') {
                        return null;
                    }
                    rslt[rsltpos++] = buff[buffpos++];
                }
            }
            varsValues = this.addAndCreateList(varsValues, new String(rslt, 0, rsltpos));
            rsltpos = 0;
        }
    }

    protected int indexOfArray(int[] r, int rpos, int rend, char[] d, int dpos) {
        if (rend < rpos) {
            throw new IllegalArgumentException("rend < rpos");
        }
        if (rend == rpos) {
            return d.length;
        }
        if (rend - rpos == 1) {
            for (int x = dpos; x < d.length; ++x) {
                if (r[rpos] != d[x]) continue;
                return x;
            }
        }
        while (dpos + rend - rpos <= d.length) {
            int y = dpos;
            for (int x = rpos; x <= rend; ++x) {
                if (x == rend) {
                    return dpos;
                }
                if (r[x] != d[y++]) break;
            }
            ++dpos;
        }
        return -1;
    }

    protected int lastIndexOfArray(int[] r, int rpos, int rend, char[] d, int dpos) {
        if (rend < rpos) {
            throw new IllegalArgumentException("rend < rpos");
        }
        if (rend == rpos) {
            return d.length;
        }
        if (rend - rpos == 1) {
            for (int x = d.length - 1; x > dpos; --x) {
                if (r[rpos] != d[x]) continue;
                return x;
            }
        }
        block1: for (int l = d.length - (rend - rpos); l >= dpos; --l) {
            int y = l;
            for (int x = rpos; x <= rend; ++x) {
                if (x == rend) {
                    return l;
                }
                if (r[x] != d[y++]) continue block1;
            }
        }
        return -1;
    }

    protected boolean matchArray(int[] r, int rpos, int rend, char[] d, int dpos) {
        if (d.length - dpos < rend - rpos) {
            return false;
        }
        for (int i = rpos; i < rend; ++i) {
            if (r[i] == d[dpos++]) continue;
            return false;
        }
        return true;
    }

    public static String convertParam(String val, Map<Integer, String> vars) {
        if (val == null) {
            return null;
        }
        if (val.indexOf("{") == -1) {
            return val;
        }
        StringBuffer key = new StringBuffer("{0}");
        StringBuffer ret = new StringBuffer(val);
        for (Map.Entry<Integer, String> entry : vars.entrySet()) {
            int x;
            key.setCharAt(1, entry.getKey().toString().charAt(0));
            String keyTmp = key.toString();
            while ((x = ret.toString().indexOf(keyTmp)) > -1) {
                ret.replace(x, x + 3, entry.getValue());
            }
        }
        return ret.toString();
    }

    private <T> List<T> addAndCreateList(List<T> list, T data) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        list.add(data);
        return list;
    }

    private <T> List<T> addElementOnTop(List<T> list, T data) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        list.add(0, data);
        return list;
    }
}

