/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.impl.AbstractFunction;
import org.jooq.impl.DSL;

class Round<T extends Number>
extends AbstractFunction<T> {
    private static final long serialVersionUID = -7273879239726265322L;
    private final Field<T> argument;
    private final int decimals;

    Round(Field<T> argument) {
        this(argument, 0);
    }

    Round(Field<T> argument, int decimals) {
        super("round", argument.getDataType(), argument);
        this.argument = argument;
        this.decimals = decimals;
    }

    @Override
    final Field<T> getFunction0(Configuration configuration) {
        switch (configuration.family()) {
            case DERBY: {
                if (this.decimals == 0) {
                    return DSL.when(this.argument.sub(DSL.floor(this.argument)).lessThan(0.5), DSL.floor(this.argument)).otherwise(DSL.ceil(this.argument));
                }
                Param<BigDecimal> factor = DSL.val(BigDecimal.ONE.movePointRight(this.decimals));
                Field<T> mul = this.argument.mul(factor);
                return DSL.when(mul.sub(DSL.floor(mul)).lessThan(0.5), DSL.floor(mul).div(factor)).otherwise(DSL.ceil(mul).div(factor));
            }
            case POSTGRES: {
                if (this.decimals == 0) {
                    return DSL.function("round", this.getDataType(), this.argument);
                }
                return DSL.function("round", this.getDataType(), this.argument.cast(BigDecimal.class), DSL.val(this.decimals));
            }
        }
        if (this.decimals == 0) {
            return DSL.function("round", this.getDataType(), this.argument);
        }
        return DSL.function("round", this.getDataType(), this.argument, DSL.val(this.decimals));
    }
}

