/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import javax.xml.bind.JAXB;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.ConverterProvider;
import org.jooq.ExecuteListenerProvider;
import org.jooq.RecordListenerProvider;
import org.jooq.RecordMapperProvider;
import org.jooq.SQLDialect;
import org.jooq.SchemaMapping;
import org.jooq.TransactionProvider;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConnectionProvider;
import org.jooq.impl.DefaultConverterProvider;
import org.jooq.impl.DefaultRecordMapperProvider;
import org.jooq.impl.DefaultTransactionProvider;
import org.jooq.impl.NoConnectionProvider;
import org.jooq.impl.NoTransactionProvider;
import org.jooq.impl.Utils;

public class DefaultConfiguration
implements Configuration {
    private static final long serialVersionUID = 8193158984283234708L;
    private SQLDialect dialect;
    private Settings settings;
    private ConcurrentHashMap<Object, Object> data;
    private transient ConnectionProvider connectionProvider;
    private transient TransactionProvider transactionProvider;
    private transient RecordMapperProvider recordMapperProvider;
    private transient RecordListenerProvider[] recordListenerProviders;
    private transient ExecuteListenerProvider[] executeListenerProviders;
    private transient VisitListenerProvider[] visitListenerProviders;
    private transient ConverterProvider converterProvider;
    private SchemaMapping mapping;

    public DefaultConfiguration() {
        this(SQLDialect.DEFAULT);
    }

    DefaultConfiguration(SQLDialect dialect) {
        this(null, null, null, null, null, null, null, dialect, SettingsTools.defaultSettings(), null);
    }

    DefaultConfiguration(Configuration configuration) {
        this(configuration.connectionProvider(), configuration.transactionProvider(), configuration.recordMapperProvider(), configuration.recordListenerProviders(), configuration.executeListenerProviders(), configuration.visitListenerProviders(), configuration.converterProvider(), configuration.dialect(), configuration.settings(), configuration.data());
    }

    @Deprecated
    DefaultConfiguration(ConnectionProvider connectionProvider, ExecuteListenerProvider[] executeListenerProviders, SQLDialect dialect, Settings settings, Map<Object, Object> data) {
        this(connectionProvider, null, null, null, executeListenerProviders, null, null, dialect, settings, data);
    }

    @Deprecated
    DefaultConfiguration(ConnectionProvider connectionProvider, RecordMapperProvider recordMapperProvider, ExecuteListenerProvider[] executeListenerProviders, SQLDialect dialect, Settings settings, Map<Object, Object> data) {
        this(connectionProvider, null, recordMapperProvider, null, executeListenerProviders, null, null, dialect, settings, data);
    }

    @Deprecated
    DefaultConfiguration(ConnectionProvider connectionProvider, RecordMapperProvider recordMapperProvider, RecordListenerProvider[] recordListenerProviders, ExecuteListenerProvider[] executeListenerProviders, VisitListenerProvider[] visitListenerProviders, SQLDialect dialect, Settings settings, Map<Object, Object> data) {
        this(connectionProvider, null, recordMapperProvider, recordListenerProviders, executeListenerProviders, visitListenerProviders, null, dialect, settings, data);
    }

    @Deprecated
    DefaultConfiguration(ConnectionProvider connectionProvider, TransactionProvider transactionProvider, RecordMapperProvider recordMapperProvider, RecordListenerProvider[] recordListenerProviders, ExecuteListenerProvider[] executeListenerProviders, VisitListenerProvider[] visitListenerProviders, SQLDialect dialect, Settings settings, Map<Object, Object> data) {
        this(connectionProvider, transactionProvider, recordMapperProvider, recordListenerProviders, executeListenerProviders, visitListenerProviders, null, dialect, settings, data);
    }

    DefaultConfiguration(ConnectionProvider connectionProvider, TransactionProvider transactionProvider, RecordMapperProvider recordMapperProvider, RecordListenerProvider[] recordListenerProviders, ExecuteListenerProvider[] executeListenerProviders, VisitListenerProvider[] visitListenerProviders, ConverterProvider converterProvider, SQLDialect dialect, Settings settings, Map<Object, Object> data) {
        this.set(connectionProvider);
        this.set(transactionProvider);
        this.set(recordMapperProvider);
        this.set(recordListenerProviders);
        this.set(executeListenerProviders);
        this.set(visitListenerProviders);
        this.set(converterProvider);
        this.set(dialect);
        this.set(settings);
        this.data = data != null ? new ConcurrentHashMap<Object, Object>(data) : new ConcurrentHashMap();
    }

    @Override
    public final Configuration derive() {
        return new DefaultConfiguration(this);
    }

    @Override
    public final Configuration derive(Connection newConnection) {
        return this.derive(new DefaultConnectionProvider(newConnection));
    }

    @Override
    public final Configuration derive(DataSource newDataSource) {
        return this.derive(new DataSourceConnectionProvider(newDataSource));
    }

    @Override
    public final Configuration derive(ConnectionProvider newConnectionProvider) {
        return new DefaultConfiguration(newConnectionProvider, this.transactionProvider, this.recordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, this.converterProvider, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(TransactionProvider newTransactionProvider) {
        return new DefaultConfiguration(this.connectionProvider, newTransactionProvider, this.recordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, this.converterProvider, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(RecordMapperProvider newRecordMapperProvider) {
        return new DefaultConfiguration(this.connectionProvider, this.transactionProvider, newRecordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, this.converterProvider, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(RecordListenerProvider ... newRecordListenerProviders) {
        return new DefaultConfiguration(this.connectionProvider, this.transactionProvider, this.recordMapperProvider, newRecordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, this.converterProvider, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(ExecuteListenerProvider ... newExecuteListenerProviders) {
        return new DefaultConfiguration(this.connectionProvider, this.transactionProvider, this.recordMapperProvider, this.recordListenerProviders, newExecuteListenerProviders, this.visitListenerProviders, this.converterProvider, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(VisitListenerProvider ... newVisitListenerProviders) {
        return new DefaultConfiguration(this.connectionProvider, this.transactionProvider, this.recordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, newVisitListenerProviders, this.converterProvider, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(ConverterProvider newConverterProvider) {
        return new DefaultConfiguration(this.connectionProvider, this.transactionProvider, this.recordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, newConverterProvider, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(SQLDialect newDialect) {
        return new DefaultConfiguration(this.connectionProvider, this.transactionProvider, this.recordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, this.converterProvider, newDialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(Settings newSettings) {
        return new DefaultConfiguration(this.connectionProvider, this.transactionProvider, this.recordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, this.converterProvider, this.dialect, newSettings, this.data);
    }

    @Override
    public final Configuration set(Connection newConnection) {
        return this.set(new DefaultConnectionProvider(newConnection));
    }

    @Override
    public final Configuration set(DataSource newDataSource) {
        return this.set(new DataSourceConnectionProvider(newDataSource));
    }

    @Override
    public final Configuration set(ConnectionProvider newConnectionProvider) {
        this.connectionProvider = newConnectionProvider != null ? newConnectionProvider : new NoConnectionProvider();
        return this;
    }

    @Override
    public final Configuration set(TransactionProvider newTransactionProvider) {
        this.transactionProvider = newTransactionProvider != null ? newTransactionProvider : new NoTransactionProvider();
        return this;
    }

    @Override
    public final Configuration set(RecordMapperProvider newRecordMapperProvider) {
        this.recordMapperProvider = newRecordMapperProvider;
        return this;
    }

    @Override
    public final Configuration set(RecordListenerProvider ... newRecordListenerProviders) {
        this.recordListenerProviders = newRecordListenerProviders != null ? newRecordListenerProviders : new RecordListenerProvider[]{};
        return this;
    }

    @Override
    public final Configuration set(ExecuteListenerProvider ... newExecuteListenerProviders) {
        this.executeListenerProviders = newExecuteListenerProviders != null ? newExecuteListenerProviders : new ExecuteListenerProvider[]{};
        return this;
    }

    @Override
    public final Configuration set(VisitListenerProvider ... newVisitListenerProviders) {
        this.visitListenerProviders = newVisitListenerProviders != null ? newVisitListenerProviders : new VisitListenerProvider[]{};
        return this;
    }

    @Override
    public final Configuration set(ConverterProvider newConverterProvider) {
        this.converterProvider = newConverterProvider != null ? newConverterProvider : new DefaultConverterProvider();
        return this;
    }

    @Override
    public final Configuration set(SQLDialect newDialect) {
        this.dialect = newDialect;
        return this;
    }

    @Override
    public final Configuration set(Settings newSettings) {
        this.settings = newSettings != null ? SettingsTools.clone(newSettings) : SettingsTools.defaultSettings();
        this.mapping = new SchemaMapping(this);
        return this;
    }

    public final void setConnection(Connection newConnection) {
        this.set(newConnection);
    }

    public final void setDataSource(DataSource newDataSource) {
        this.set(newDataSource);
    }

    public final void setConnectionProvider(ConnectionProvider newConnectionProvider) {
        this.set(newConnectionProvider);
    }

    public final void setTransactionProvider(TransactionProvider newTransactionProvider) {
        this.set(newTransactionProvider);
    }

    public final void setRecordMapperProvider(RecordMapperProvider newRecordMapperProvider) {
        this.set(newRecordMapperProvider);
    }

    public final void setRecordListenerProvider(RecordListenerProvider ... newRecordListenerProviders) {
        this.set(newRecordListenerProviders);
    }

    public final void setExecuteListenerProvider(ExecuteListenerProvider ... newExecuteListenerProviders) {
        this.set(newExecuteListenerProviders);
    }

    public final void setVisitListenerProvider(VisitListenerProvider ... newVisitListenerProviders) {
        this.set(newVisitListenerProviders);
    }

    public final void setSQLDialect(SQLDialect newDialect) {
        this.set(newDialect);
    }

    public final void setSettings(Settings newSettings) {
        this.set(newSettings);
    }

    @Override
    public final ConnectionProvider connectionProvider() {
        ConnectionProvider transactional = (ConnectionProvider)this.data((Object)Utils.DataKey.DATA_DEFAULT_TRANSACTION_PROVIDER_CONNECTION);
        return transactional == null ? this.connectionProvider : transactional;
    }

    @Override
    public final TransactionProvider transactionProvider() {
        if (this.transactionProvider instanceof NoTransactionProvider) {
            return new DefaultTransactionProvider(this.connectionProvider);
        }
        return this.transactionProvider;
    }

    @Override
    public final RecordMapperProvider recordMapperProvider() {
        return this.recordMapperProvider != null ? this.recordMapperProvider : new DefaultRecordMapperProvider(this);
    }

    @Override
    public final RecordListenerProvider[] recordListenerProviders() {
        return this.recordListenerProviders;
    }

    @Override
    public final ExecuteListenerProvider[] executeListenerProviders() {
        return this.executeListenerProviders;
    }

    @Override
    public final VisitListenerProvider[] visitListenerProviders() {
        return this.visitListenerProviders;
    }

    @Override
    public final ConverterProvider converterProvider() {
        return this.converterProvider;
    }

    @Override
    public final SQLDialect dialect() {
        return this.dialect;
    }

    @Override
    public final SQLDialect family() {
        return this.dialect.family();
    }

    @Override
    public final Settings settings() {
        return this.settings;
    }

    public final ConcurrentHashMap<Object, Object> data() {
        return this.data;
    }

    @Override
    public final Object data(Object key) {
        return this.data.get(key);
    }

    @Override
    public final Object data(Object key, Object value) {
        return this.data.put(key, value);
    }

    @Override
    @Deprecated
    public final SchemaMapping schemaMapping() {
        return this.mapping;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)this.settings, (Writer)writer);
        return "DefaultConfiguration [\n\tconnected=" + (this.connectionProvider != null && !(this.connectionProvider instanceof NoConnectionProvider)) + ",\n\ttransactional=" + (this.transactionProvider != null && !(this.transactionProvider instanceof NoTransactionProvider)) + ",\n\tdialect=" + (Object)((Object)this.dialect) + ",\n\tdata=" + this.data + ",\n\tsettings=\n\t\t" + writer.toString().trim().replace("\n", "\n\t\t") + "\n]";
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.connectionProvider instanceof Serializable ? this.connectionProvider : null);
        oos.writeObject(this.transactionProvider instanceof Serializable ? this.transactionProvider : null);
        oos.writeObject(this.recordMapperProvider instanceof Serializable ? this.recordMapperProvider : null);
        oos.writeObject(this.cloneSerializables(this.executeListenerProviders));
        oos.writeObject(this.cloneSerializables(this.recordListenerProviders));
        oos.writeObject(this.cloneSerializables(this.visitListenerProviders));
        oos.writeObject(this.converterProvider instanceof Serializable ? this.converterProvider : null);
    }

    private <E> E[] cloneSerializables(E[] array) {
        Object[] clone = (Object[])array.clone();
        for (int i = 0; i < clone.length; ++i) {
            if (clone[i] instanceof Serializable) continue;
            clone[i] = null;
        }
        return clone;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.connectionProvider = (ConnectionProvider)ois.readObject();
        this.transactionProvider = (TransactionProvider)ois.readObject();
        this.recordMapperProvider = (RecordMapperProvider)ois.readObject();
        this.executeListenerProviders = (ExecuteListenerProvider[])ois.readObject();
        this.recordListenerProviders = (RecordListenerProvider[])ois.readObject();
        this.visitListenerProviders = (VisitListenerProvider[])ois.readObject();
        this.converterProvider = (ConverterProvider)ois.readObject();
    }
}

