/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.util.EnumSet;

public enum SQLDialect {
    SQL99("", false),
    DEFAULT("", false),
    CUBRID("CUBRID", false),
    DERBY("Derby", false),
    FIREBIRD("Firebird", false),
    H2("H2", false),
    HSQLDB("HSQLDB", false),
    MARIADB("MariaDB", false),
    MYSQL("MySQL", false),
    POSTGRES("Postgres", false),
    POSTGRES_9_3("Postgres", false, POSTGRES, null),
    POSTGRES_9_4("Postgres", false, POSTGRES, POSTGRES_9_3),
    POSTGRES_9_5("Postgres", false, POSTGRES, POSTGRES_9_4),
    SQLITE("SQLite", false);

    private static final SQLDialect[] FAMILIES;
    private final String name;
    private final boolean commercial;
    private final SQLDialect family;
    private SQLDialect predecessor;
    private final ThirdParty thirdParty;

    private SQLDialect(String name, boolean commercial) {
        this(name, commercial, null, null);
    }

    private SQLDialect(String name, boolean commercial, SQLDialect family) {
        this(name, commercial, family, null);
    }

    private SQLDialect(String name, boolean commercial, SQLDialect family, SQLDialect predecessor) {
        this.name = name;
        this.commercial = commercial;
        this.family = family == null ? this : family;
        SQLDialect sQLDialect = this.predecessor = predecessor == null ? this : predecessor;
        if (family != null) {
            family.predecessor = this;
        }
        this.thirdParty = new ThirdParty();
    }

    public final boolean commercial() {
        return this.commercial;
    }

    public final SQLDialect family() {
        return this.family;
    }

    public final SQLDialect predecessor() {
        return this.predecessor;
    }

    public final boolean precedes(SQLDialect other) {
        if (this.family != other.family) {
            return false;
        }
        for (SQLDialect candidate = other; candidate != null; candidate = candidate.predecessor()) {
            if (this == candidate) {
                return true;
            }
            if (candidate != candidate.predecessor()) continue;
            return false;
        }
        return false;
    }

    public final String getName() {
        return this.name;
    }

    public final String getNameLC() {
        return this.name == null ? null : this.name.toLowerCase();
    }

    public final String getNameUC() {
        return this.name == null ? null : this.name.toUpperCase();
    }

    public static final SQLDialect[] families() {
        return (SQLDialect[])FAMILIES.clone();
    }

    public final ThirdParty thirdParty() {
        return this.thirdParty;
    }

    static {
        EnumSet<SQLDialect> set = EnumSet.noneOf(SQLDialect.class);
        for (SQLDialect dialect : SQLDialect.values()) {
            set.add(dialect.family());
        }
        FAMILIES = set.toArray(new SQLDialect[set.size()]);
    }

    public final class ThirdParty {
        public final String springDbName() {
            switch (SQLDialect.this.family) {
                case DERBY: {
                    return "Derby";
                }
                case H2: {
                    return "H2";
                }
                case HSQLDB: {
                    return "HSQL";
                }
                case MARIADB: 
                case MYSQL: {
                    return "MySQL";
                }
                case POSTGRES: {
                    return "PostgreSQL";
                }
            }
            return null;
        }

        public final String hibernateDialect() {
            switch (SQLDialect.this) {
                case CUBRID: {
                    return "org.hibernate.dialect.CUBRIDDialect";
                }
                case DERBY: {
                    return "org.hibernate.dialect.DerbyTenSevenDialect";
                }
                case FIREBIRD: {
                    return "org.hibernate.dialect.FirebirdDialect";
                }
                case H2: {
                    return "org.hibernate.dialect.H2Dialect";
                }
                case HSQLDB: {
                    return "org.hibernate.dialect.HSQLDialect";
                }
                case MARIADB: 
                case MYSQL: {
                    return "org.hibernate.dialect.MySQL5Dialect";
                }
                case POSTGRES_9_3: {
                    return "org.hibernate.dialect.PostgreSQL92Dialect";
                }
                case POSTGRES: 
                case POSTGRES_9_4: 
                case POSTGRES_9_5: {
                    return "org.hibernate.dialect.PostgreSQL94Dialect";
                }
                case SQLITE: {
                    return null;
                }
            }
            return null;
        }
    }
}

