/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.config.annotation.web.http;

import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.IndexFactoryBean;
import org.springframework.data.gemfire.IndexType;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.session.ExpiringSession;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.data.gemfire.AbstractGemFireOperationsSessionRepository;
import org.springframework.session.data.gemfire.GemFireOperationsSessionRepository;
import org.springframework.session.data.gemfire.config.annotation.web.http.EnableGemFireHttpSession;
import org.springframework.session.data.gemfire.config.annotation.web.http.support.GemFireCacheTypeAwareRegionFactoryBean;
import org.springframework.session.data.gemfire.support.GemFireUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
public class GemFireHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements BeanClassLoaderAware,
ImportAware {
    public static final int DEFAULT_MAX_INACTIVE_INTERVAL_IN_SECONDS = (int)TimeUnit.MINUTES.toSeconds(30L);
    protected static final Class<Object> SPRING_SESSION_GEMFIRE_REGION_KEY_CONSTRAINT = Object.class;
    protected static final Class<AbstractGemFireOperationsSessionRepository.GemFireSession> SPRING_SESSION_GEMFIRE_REGION_VALUE_CONSTRAINT = AbstractGemFireOperationsSessionRepository.GemFireSession.class;
    public static final ClientRegionShortcut DEFAULT_CLIENT_REGION_SHORTCUT = ClientRegionShortcut.PROXY;
    public static final RegionShortcut DEFAULT_SERVER_REGION_SHORTCUT = RegionShortcut.PARTITION;
    public static final String DEFAULT_SPRING_SESSION_GEMFIRE_REGION_NAME = "ClusteredSpringSessions";
    public static final String[] DEFAULT_INDEXABLE_SESSION_ATTRIBUTES = new String[0];
    private int maxInactiveIntervalInSeconds = DEFAULT_MAX_INACTIVE_INTERVAL_IN_SECONDS;
    private ClassLoader beanClassLoader;
    private ClientRegionShortcut clientRegionShortcut = DEFAULT_CLIENT_REGION_SHORTCUT;
    private RegionShortcut serverRegionShortcut = DEFAULT_SERVER_REGION_SHORTCUT;
    private String springSessionGemFireRegionName = "ClusteredSpringSessions";
    private String[] indexableSessionAttributes = DEFAULT_INDEXABLE_SESSION_ATTRIBUTES;

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setClientRegionShortcut(ClientRegionShortcut shortcut) {
        this.clientRegionShortcut = shortcut;
    }

    protected ClientRegionShortcut getClientRegionShortcut() {
        return this.clientRegionShortcut != null ? this.clientRegionShortcut : DEFAULT_CLIENT_REGION_SHORTCUT;
    }

    public void setIndexableSessionAttributes(String[] indexableSessionAttributes) {
        this.indexableSessionAttributes = indexableSessionAttributes;
    }

    protected String[] getIndexableSessionAttributes() {
        return this.indexableSessionAttributes != null ? this.indexableSessionAttributes : DEFAULT_INDEXABLE_SESSION_ATTRIBUTES;
    }

    protected String getIndexableSessionAttributesAsGemFireIndexExpression() {
        StringBuilder builder = new StringBuilder();
        for (String sessionAttribute : this.getIndexableSessionAttributes()) {
            builder.append(builder.length() > 0 ? ", " : "");
            builder.append(String.format("'%1$s'", sessionAttribute));
        }
        String indexExpression = builder.toString();
        return indexExpression.isEmpty() ? "*" : indexExpression;
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    protected int getMaxInactiveIntervalInSeconds() {
        return this.maxInactiveIntervalInSeconds;
    }

    public void setServerRegionShortcut(RegionShortcut shortcut) {
        this.serverRegionShortcut = shortcut;
    }

    protected RegionShortcut getServerRegionShortcut() {
        return this.serverRegionShortcut != null ? this.serverRegionShortcut : DEFAULT_SERVER_REGION_SHORTCUT;
    }

    public void setSpringSessionGemFireRegionName(String springSessionGemFireRegionName) {
        this.springSessionGemFireRegionName = springSessionGemFireRegionName;
    }

    protected String getSpringSessionGemFireRegionName() {
        return StringUtils.hasText((String)this.springSessionGemFireRegionName) ? this.springSessionGemFireRegionName : DEFAULT_SPRING_SESSION_GEMFIRE_REGION_NAME;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes enableGemFireHttpSessionAnnotationAttributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableGemFireHttpSession.class.getName()));
        this.setClientRegionShortcut((ClientRegionShortcut)ClientRegionShortcut.class.cast(enableGemFireHttpSessionAnnotationAttributes.getEnum("clientRegionShortcut")));
        this.setIndexableSessionAttributes(enableGemFireHttpSessionAnnotationAttributes.getStringArray("indexableSessionAttributes"));
        this.setMaxInactiveIntervalInSeconds(enableGemFireHttpSessionAnnotationAttributes.getNumber("maxInactiveIntervalInSeconds").intValue());
        this.setServerRegionShortcut((RegionShortcut)RegionShortcut.class.cast(enableGemFireHttpSessionAnnotationAttributes.getEnum("serverRegionShortcut")));
        this.setSpringSessionGemFireRegionName(enableGemFireHttpSessionAnnotationAttributes.getString("regionName"));
    }

    @Bean
    public GemFireOperationsSessionRepository sessionRepository(@Qualifier(value="sessionRegionTemplate") GemfireOperations gemfireOperations) {
        GemFireOperationsSessionRepository sessionRepository = new GemFireOperationsSessionRepository(gemfireOperations);
        sessionRepository.setMaxInactiveIntervalInSeconds(this.getMaxInactiveIntervalInSeconds());
        return sessionRepository;
    }

    @Bean
    @DependsOn(value={"ClusteredSpringSessions"})
    public GemfireTemplate sessionRegionTemplate(GemFireCache gemFireCache) {
        return new GemfireTemplate(gemFireCache.getRegion(this.getSpringSessionGemFireRegionName()));
    }

    @Bean(name={"ClusteredSpringSessions"})
    public GemFireCacheTypeAwareRegionFactoryBean<Object, ExpiringSession> sessionRegion(GemFireCache gemfireCache, RegionAttributes<Object, ExpiringSession> sessionRegionAttributes) {
        GemFireCacheTypeAwareRegionFactoryBean<Object, ExpiringSession> serverRegion = new GemFireCacheTypeAwareRegionFactoryBean<Object, ExpiringSession>();
        serverRegion.setGemfireCache(gemfireCache);
        serverRegion.setClientRegionShortcut(this.getClientRegionShortcut());
        serverRegion.setRegionAttributes(sessionRegionAttributes);
        serverRegion.setRegionName(this.getSpringSessionGemFireRegionName());
        serverRegion.setServerRegionShortcut(this.getServerRegionShortcut());
        return serverRegion;
    }

    @Bean
    public RegionAttributesFactoryBean sessionRegionAttributes(GemFireCache gemfireCache) {
        RegionAttributesFactoryBean regionAttributes = new RegionAttributesFactoryBean();
        regionAttributes.setKeyConstraint(SPRING_SESSION_GEMFIRE_REGION_KEY_CONSTRAINT);
        regionAttributes.setValueConstraint(SPRING_SESSION_GEMFIRE_REGION_VALUE_CONSTRAINT);
        if (this.isExpirationAllowed(gemfireCache)) {
            regionAttributes.setStatisticsEnabled(true);
            regionAttributes.setEntryIdleTimeout(new ExpirationAttributes(Math.max(this.getMaxInactiveIntervalInSeconds(), 0), ExpirationAction.INVALIDATE));
        }
        return regionAttributes;
    }

    boolean isExpirationAllowed(GemFireCache gemfireCache) {
        return !(!GemFireUtils.isClient(gemfireCache) ? GemFireUtils.isProxy(this.getServerRegionShortcut()) : GemFireUtils.isProxy(this.getClientRegionShortcut()));
    }

    @Bean
    @DependsOn(value={"ClusteredSpringSessions"})
    public IndexFactoryBean principalNameIndex(final GemFireCache gemfireCache) {
        IndexFactoryBean index = new IndexFactoryBean(){

            public void afterPropertiesSet() throws Exception {
                if (GemFireUtils.isPeer(gemfireCache)) {
                    super.afterPropertiesSet();
                }
            }
        };
        index.setCache((RegionService)gemfireCache);
        index.setName("principalNameIndex");
        index.setExpression("principalName");
        index.setFrom(GemFireUtils.toRegionPath(this.getSpringSessionGemFireRegionName()));
        index.setOverride(true);
        index.setType(IndexType.HASH);
        return index;
    }

    @Bean
    @DependsOn(value={"ClusteredSpringSessions"})
    public IndexFactoryBean sessionAttributesIndex(final GemFireCache gemfireCache) {
        IndexFactoryBean index = new IndexFactoryBean(){

            public void afterPropertiesSet() throws Exception {
                if (GemFireUtils.isPeer(gemfireCache) && !ObjectUtils.isEmpty((Object[])GemFireHttpSessionConfiguration.this.getIndexableSessionAttributes())) {
                    super.afterPropertiesSet();
                }
            }
        };
        index.setCache((RegionService)gemfireCache);
        index.setName("sessionAttributesIndex");
        index.setExpression(String.format("s.attributes[%1$s]", this.getIndexableSessionAttributesAsGemFireIndexExpression()));
        index.setFrom(String.format("%1$s s", GemFireUtils.toRegionPath(this.getSpringSessionGemFireRegionName())));
        index.setOverride(true);
        return index;
    }
}

