/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.validation.constraints.impl;

import blue.hive.validation.constraints.BHiveMaxLength;
import blue.hive.validation.constraints.impl.BHiveConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class BHiveMaxLengthValidatorForInteger
extends BHiveConstraintValidator<BHiveMaxLength, Integer> {
    private int maxLength;

    @Override
    public void initialize(BHiveMaxLength constraintAnnotation) {
        this.maxLength = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(Integer value, ConstraintValidatorContext context) {
        boolean result;
        if (value == null) {
            return true;
        }
        boolean bl = result = Integer.toString(Math.abs(value)).length() <= this.maxLength;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("isValid({}) maxLength:{} => {}", new Object[]{value, this.maxLength, result});
        }
        return result;
    }
}

