/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.util.StringUtils;

public class BHiveIOUtil {
    public static String readStringToEnd(InputStream is) throws IOException {
        return BHiveIOUtil.readStringToEnd(is, "UTF-8");
    }

    public static String readStringToEnd(InputStream is, String charsetName) throws IOException {
        String body = new String(BHiveIOUtil.readBytesToEnd(is), Charset.forName(charsetName));
        return StringUtils.trimTrailingWhitespace((String)body);
    }

    public static byte[] readBytesToEnd(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = is.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toByteArray();
    }

    public static boolean isPlainDir(File file) throws IOException {
        return file.isDirectory() && !BHiveIOUtil.isSymbolicLink(file);
    }

    public static boolean isSymbolicLink(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        File canon = null;
        if (file.getParent() == null) {
            canon = file;
        } else {
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                File canonDir = parentFile.getCanonicalFile();
                canon = new File(canonDir, file.getName());
            } else {
                throw new NullPointerException("File must not be null");
            }
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }
}

