/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.util;

import blue.hive.type.BHiveValueEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BHiveEnumUtil {
    protected static Logger logger = LoggerFactory.getLogger(BHiveEnumUtil.class);

    public static <E extends Enum<E>> Boolean isNotSet(E e) {
        String stringValue = e.toString();
        if (e instanceof BHiveValueEnum) {
            BHiveValueEnum et = (BHiveValueEnum)((Object)e);
            String value = et.getValue() == null ? "" : et.getValue().toString();
            return value.equals("NOT_SET") || value.equals("NOTSET") || value.equals("") || stringValue.equals("NOT_SET") || stringValue.equals("NOTSET") || stringValue.equals("");
        }
        return stringValue.equals("NOT_SET") || stringValue.equals("NOTSET") || stringValue.equals("");
    }

    public static <E extends Enum<E>> List<E> getEnumKeys(Class<E> elementType) {
        return BHiveEnumUtil.getEnumKeys(elementType, true);
    }

    public static <E extends Enum<E>> List<E> getEnumKeys(Class<E> elementType, Boolean excludeNotSet) {
        ArrayList<Enum> result = new ArrayList<Enum>();
        EnumSet<Enum> enumSet = EnumSet.allOf(elementType);
        for (Enum e : enumSet) {
            if (excludeNotSet.booleanValue() && BHiveEnumUtil.isNotSet(e).booleanValue()) continue;
            result.add(e);
        }
        return result;
    }

    public static <E extends Enum<E>> List<String> getEnumKeyStrings(Class<E> elementType) {
        return BHiveEnumUtil.getEnumKeyStrings(elementType, true);
    }

    public static <E extends Enum<E>> List<String> getEnumKeyStrings(Class<E> elementType, Boolean excludeNotSet) {
        ArrayList<String> result = new ArrayList<String>();
        EnumSet<Enum> enumSet = EnumSet.allOf(elementType);
        for (Enum e : enumSet) {
            if (excludeNotSet.booleanValue() && BHiveEnumUtil.isNotSet(e).booleanValue()) continue;
            result.add(e.toString());
        }
        return result;
    }

    public static <E extends Enum<E>, T> List<T> getEnumValues(Class<E> elementType) {
        return BHiveEnumUtil.getEnumValues(elementType, true);
    }

    public static <E extends Enum<E>, T> List<T> getEnumValues(Class<E> elementType, Boolean excludeNotSet) {
        return BHiveEnumUtil.convertToEnumValues(Arrays.asList(elementType.getEnumConstants()), excludeNotSet);
    }

    public static <E extends Enum<E>, T> List<T> convertToEnumValues(Iterable<? extends E> enumArray, Boolean excludeNotSet) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Enum e : enumArray) {
            if (excludeNotSet.booleanValue() && BHiveEnumUtil.isNotSet(e).booleanValue()) continue;
            if (e instanceof BHiveValueEnum) {
                BHiveValueEnum et = (BHiveValueEnum)((Object)e);
                result.add(et.getValue());
                continue;
            }
            result.add(e);
        }
        return result;
    }

    public static <E extends Enum<E>> List<String> getEnumValueStrings(Class<E> elementType) {
        return BHiveEnumUtil.getEnumValueStrings(elementType, true);
    }

    public static <E extends Enum<E>> List<String> getEnumValueStrings(Class<E> elementType, Boolean excludeNotSet) {
        return BHiveEnumUtil.convertToEnumValueStrings(Arrays.asList(elementType.getEnumConstants()), excludeNotSet);
    }

    public static <E extends Enum<E>> List<String> convertToEnumValueStrings(Iterable<? extends E> enumArray, Boolean excludeNotSet) {
        ArrayList<String> result = new ArrayList<String>();
        for (Enum e : enumArray) {
            if (excludeNotSet.booleanValue() && BHiveEnumUtil.isNotSet(e).booleanValue()) continue;
            if (e instanceof BHiveValueEnum) {
                BHiveValueEnum et = (BHiveValueEnum)((Object)e);
                result.add(et.getValue().toString());
                continue;
            }
            result.add(e.toString());
        }
        return result;
    }

    public static <E extends Enum<E>> List<String> convertToEnumKeyStrings(Iterable<? extends E> enumArray, Boolean excludeNotSet) {
        ArrayList<String> result = new ArrayList<String>();
        for (Enum e : enumArray) {
            if (excludeNotSet.booleanValue() && BHiveEnumUtil.isNotSet(e).booleanValue()) continue;
            result.add(e.toString());
        }
        return result;
    }

    public static <E extends Enum<E>, T> Map<E, T> getEnumKeyValueMap(Class<E> elementType) {
        return BHiveEnumUtil.getEnumKeyValueMap(elementType, true);
    }

    public static <E extends Enum<E>, T> Map<E, T> getEnumKeyValueMap(Class<E> elementType, Boolean excludeNotSet) {
        return BHiveEnumUtil.convertToEnumKeyValueMap(Arrays.asList(elementType.getEnumConstants()), excludeNotSet);
    }

    public static <E extends Enum<E>, T> Map<E, T> convertToEnumKeyValueMap(Iterable<? extends E> enumArray, Boolean excludeNotSet) {
        LinkedHashMap<Enum, Object> result = new LinkedHashMap<Enum, Object>();
        for (Enum e : enumArray) {
            if (excludeNotSet.booleanValue() && BHiveEnumUtil.isNotSet(e).booleanValue()) continue;
            if (e instanceof BHiveValueEnum) {
                BHiveValueEnum et = (BHiveValueEnum)((Object)e);
                result.put(e, et.getValue());
                continue;
            }
            result.put(e, e);
        }
        return result;
    }

    public static <E extends Enum<E>, T> Map<String, T> getEnumKeyStringValueMap(Class<E> elementType) {
        return BHiveEnumUtil.getEnumKeyStringValueMap(elementType, true);
    }

    public static <E extends Enum<E>, T> Map<String, T> getEnumKeyStringValueMap(Class<E> elementType, Boolean excludeNotSet) {
        return BHiveEnumUtil.convertToEnumKeyStringValueMap(Arrays.asList(elementType.getEnumConstants()), excludeNotSet);
    }

    public static <E extends Enum<E>, T> Map<String, T> convertToEnumKeyStringValueMap(Iterable<? extends E> enumArray, Boolean excludeNotSet) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Enum e : enumArray) {
            if (excludeNotSet.booleanValue() && BHiveEnumUtil.isNotSet(e).booleanValue()) continue;
            if (e instanceof BHiveValueEnum) {
                BHiveValueEnum et = (BHiveValueEnum)((Object)e);
                result.put(e.toString(), et.getValue());
                continue;
            }
            result.put(e.toString(), e);
        }
        return result;
    }

    public static <E extends Enum<E>> Map<String, String> getEnumKeyStringValueStringMap(Class<E> elementType) {
        return BHiveEnumUtil.getEnumKeyStringValueStringMap(elementType, true);
    }

    public static <E extends Enum<E>> Map<String, String> getEnumKeyStringValueStringMap(Class<E> elementType, Boolean excludeNotSet) {
        return BHiveEnumUtil.convertToEnumKeyStringValueStringMap(Arrays.asList(elementType.getEnumConstants()), excludeNotSet);
    }

    public static <E extends Enum<E>> Map<String, String> convertToEnumKeyStringValueStringMap(Iterable<? extends E> enumArray, Boolean excludeNotSet) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Enum e : enumArray) {
            if (excludeNotSet.booleanValue() && BHiveEnumUtil.isNotSet(e).booleanValue()) continue;
            if (e instanceof BHiveValueEnum) {
                BHiveValueEnum et = (BHiveValueEnum)((Object)e);
                result.put(e.toString(), et.getValue() == null ? "" : et.getValue().toString());
                continue;
            }
            result.put(e.toString(), e.toString());
        }
        return result;
    }

    public static <E extends Enum<E>> Set<Map.Entry<String, String>> getEnumKeyValueEntrySet(Class<E> elementType) {
        return BHiveEnumUtil.getEnumKeyValueEntrySet(elementType, true);
    }

    public static <E extends Enum<E>> Set<Map.Entry<String, String>> getEnumKeyValueEntrySet(Class<E> elementType, Boolean excludeNotSet) {
        return BHiveEnumUtil.convertToEnumKeyValueEntrySet(Arrays.asList(elementType.getEnumConstants()), excludeNotSet);
    }

    public static <E extends Enum<E>> Set<Map.Entry<String, String>> convertToEnumKeyValueEntrySet(Iterable<? extends E> enumArray, Boolean excludeNotSet) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Enum e : enumArray) {
            if (excludeNotSet.booleanValue() && BHiveEnumUtil.isNotSet(e).booleanValue()) continue;
            if (e instanceof BHiveValueEnum) {
                BHiveValueEnum et = (BHiveValueEnum)((Object)e);
                result.put(e.toString(), et.getValue() == null ? "" : et.getValue().toString());
                continue;
            }
            result.put(e.toString(), e.toString());
        }
        return result.entrySet();
    }

    public static <E extends Enum<E>, T> E parseEnumValueOf(Class<E> elementType, T value) {
        for (Enum e : (Enum[])elementType.getEnumConstants()) {
            BHiveValueEnum et;
            if (e instanceof BHiveValueEnum && ((et = (BHiveValueEnum)((Object)e)).getValue() == value || et.getValue() != null && et.getValue().toString().equals(value.toString()))) {
                return (E)e;
            }
            if (!e.toString().equals(value.toString())) continue;
            return (E)e;
        }
        return null;
    }

    public static <E extends Enum<E>, T> Object convertToCodeValue(Class<E> elementType, T value) {
        E e = BHiveEnumUtil.parseEnumValueOf(elementType, value);
        if (e instanceof BHiveValueEnum) {
            BHiveValueEnum et = (BHiveValueEnum)e;
            return et.getValue();
        }
        return null;
    }

    public static <E extends Enum<E>, T> String convertToCodeKeyString(Class<E> elementType, T value) {
        E e = BHiveEnumUtil.parseEnumValueOf(elementType, value);
        if (e instanceof BHiveValueEnum) {
            BHiveValueEnum et = (BHiveValueEnum)e;
            return et.toString();
        }
        return null;
    }
}

