/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.web.servlet.mvc.method.annotation;

import blue.hive.crypto.AES256Crypto;
import blue.hive.io.BHiveTeeInputStreamWrapper;
import blue.hive.io.BHiveTeeOutputStreamWrapper;
import blue.hive.spring.http.BHiveTeeHttpInputMessage;
import blue.hive.spring.http.BHiveTeeHttpOutputMessage;
import blue.hive.spring.web.bind.annotation.SecuredRequestBody;
import blue.hive.spring.web.bind.annotation.SecuredResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Type;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodProcessor;

public abstract class BHiveSecuredRequestResponseBodyMethodProcessor
extends AbstractMessageConverterMethodProcessor
implements InitializingBean {
    protected String secretKey = "";

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isEmpty((Object)this.secretKey)) {
            this.logger.info((Object)"!!!!!!!!! Secret Key is empty !!!!!!!!! => check set secretKey property.");
        }
    }

    public BHiveSecuredRequestResponseBodyMethodProcessor(List<HttpMessageConverter<?>> messageConverters) {
        super(messageConverters);
    }

    public BHiveSecuredRequestResponseBodyMethodProcessor(List<HttpMessageConverter<?>> messageConverters, ContentNegotiationManager contentNegotiationManager) {
        super(messageConverters, contentNegotiationManager);
    }

    public BHiveSecuredRequestResponseBodyMethodProcessor(List<HttpMessageConverter<?>> messageConverters, ContentNegotiationManager contentNegotiationManager, List<Object> responseBodyAdvice) {
        super(messageConverters, contentNegotiationManager, responseBodyAdvice);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(SecuredRequestBody.class);
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return AnnotationUtils.findAnnotation((Class)returnType.getContainingClass(), SecuredResponseBody.class) != null || returnType.getMethodAnnotation(SecuredResponseBody.class) != null;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Object arg = this.readWithMessageConverters(webRequest, parameter, parameter.getGenericParameterType());
        String name = Conventions.getVariableNameForParameter((MethodParameter)parameter);
        WebDataBinder binder = binderFactory.createBinder(webRequest, arg, name);
        if (arg != null) {
            this.validateIfApplicable(binder, parameter);
            if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
                throw new MethodArgumentNotValidException(parameter, binder.getBindingResult());
            }
        }
        mavContainer.addAttribute(BindingResult.MODEL_KEY_PREFIX + name, (Object)binder.getBindingResult());
        return arg;
    }

    protected <T> Object readWithMessageConverters(NativeWebRequest webRequest, MethodParameter methodParam, Type paramType) throws IOException, HttpMediaTypeNotSupportedException {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        ServletServerHttpRequest inputMessage = new ServletServerHttpRequest(servletRequest);
        InputStream inputStream = inputMessage.getBody();
        if (inputStream == null) {
            return this.handleEmptyBody(methodParam);
        }
        if (inputStream.markSupported()) {
            inputStream.mark(1);
            if (inputStream.read() == -1) {
                return this.handleEmptyBody(methodParam);
            }
        } else {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
            int b = pushbackInputStream.read();
            if (b == -1) {
                return this.handleEmptyBody(methodParam);
            }
            pushbackInputStream.unread(b);
            AES256Crypto crypto = new AES256Crypto(this.secretKey);
            BHiveTeeInputStreamWrapper teeInputStream = new BHiveTeeInputStreamWrapper(pushbackInputStream);
            final InputStream cipherInputStream = crypto.getDecryptChiperInputStream(teeInputStream.getInputStream());
            inputMessage = new ServletServerHttpRequest(servletRequest){

                public InputStream getBody() throws IOException {
                    return cipherInputStream;
                }
            };
            BHiveTeeHttpInputMessage teeDecryptedHttpInputMessage = new BHiveTeeHttpInputMessage((HttpInputMessage)inputMessage);
            try {
                Object result = super.readWithMessageConverters((HttpInputMessage)teeDecryptedHttpInputMessage, methodParam, paramType);
                cipherInputStream.close();
                String requestBody = teeInputStream.getTeeInputString();
                String decryptedRequestBody = teeDecryptedHttpInputMessage.getTeeInputString();
                this.logger.debug((Object)("\r\n  >>>> READ " + requestBody + "\r\n  >>>>      => " + decryptedRequestBody + "\r\n  >>>>      => " + result));
                return result;
            }
            catch (Exception ex) {
                String requestBody = teeInputStream.getTeeInputString();
                this.logger.debug((Object)("\r\n  >>>> READ {}" + requestBody + "\r\n  >>>>      => FAILED TO READ CRYPTO REQUEST BODY!! exception: " + ex.getMessage()));
                throw new HttpMessageNotReadableException("FAILED TO READ CRYPTO REQUEST BODY!! requestBody: " + requestBody, (Throwable)ex);
            }
        }
        inputStream.reset();
        return super.readWithMessageConverters((HttpInputMessage)inputMessage, methodParam, paramType);
    }

    private Object handleEmptyBody(MethodParameter param) {
        SecuredRequestBody body = (SecuredRequestBody)param.getParameterAnnotation(SecuredRequestBody.class);
        if (body != null && body.required()) {
            throw new HttpMessageNotReadableException("Required request body content is missing: " + param);
        }
        return null;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws IOException, HttpMediaTypeNotAcceptableException {
        mavContainer.setRequestHandled(true);
        this.writeWithMessageConverters(returnValue, returnType, webRequest);
    }

    protected ServletServerHttpResponse createOutputMessage(NativeWebRequest webRequest) {
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        return new ServletServerHttpResponse(response);
    }

    protected <T> void writeWithMessageConverters(T returnValue, MethodParameter returnType, NativeWebRequest webRequest) throws IOException, HttpMediaTypeNotAcceptableException {
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        BHiveTeeHttpOutputMessage teeHttpOutputMessage = new BHiveTeeHttpOutputMessage((HttpOutputMessage)outputMessage);
        AES256Crypto crypto = new AES256Crypto(this.secretKey);
        OutputStream cipherOutputStream = crypto.getEncryptChiperOutputStream(teeHttpOutputMessage.getBody());
        final BHiveTeeOutputStreamWrapper teeOutputStream = new BHiveTeeOutputStreamWrapper(cipherOutputStream);
        HttpServletResponse response = outputMessage.getServletResponse();
        ServletServerHttpResponse outputMessageWrap = new ServletServerHttpResponse(response){

            public OutputStream getBody() throws IOException {
                super.getBody();
                return teeOutputStream.getOutputStream();
            }
        };
        try {
            this.writeWithMessageConverters(returnValue, returnType, inputMessage, outputMessageWrap);
            cipherOutputStream.close();
            String responseBodyPlain = teeOutputStream.getTeeOutputString();
            String responseBody = teeHttpOutputMessage.getTeeOutputString();
            this.logger.debug((Object)("\r\n  >>>> WRITE " + responseBodyPlain + "\r\n  >>>>      => " + responseBody));
        }
        catch (Exception ex) {
            String responseBody = teeHttpOutputMessage.getTeeOutputString();
            this.logger.debug((Object)("\r\n  >>>> WRITE {}" + responseBody + "\r\n  >>>>      => FAILED TO WRITE CRYPTO RESPONSE BODY!! exception: " + ex.getMessage()));
            throw new HttpMessageNotWritableException("FAILED TO WRITE CRYPTO RESPONSE BODY!!", (Throwable)ex);
        }
    }
}

