/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.web.log;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

@Aspect
public class BHiveServiceLoggingAspect {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="within(@org.springframework.stereotype.Service *)")
    public void service() {
    }

    @Pointcut(value="execution(* *(..))")
    public void methodPointcut() {
    }

    @Before(value="service() && methodPointcut()")
    public void beforeServiceMethod(JoinPoint joinPoint) throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\r\n\t##################################################\r\n\t#### START " + BHiveServiceLoggingAspect.niceNameForStart(joinPoint));
        }
    }

    @AfterReturning(pointcut="service() && methodPointcut()", returning="retVal")
    public void afterServiceMethod(JoinPoint joinPoint, Object retVal) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\r\n\t#### END " + BHiveServiceLoggingAspect.niceNameForEnd(joinPoint, retVal) + "\r\n\t##################################################");
        }
    }

    @AfterThrowing(pointcut="service() && methodPointcut()", throwing="ex")
    public void afterThrowing(JoinPoint joinPoint, Throwable ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\r\n\t#### EXCEPTION AT " + this.niceNameForException(joinPoint, ex) + "\r\n\t##################################################");
        }
    }

    @Around(value="service() && methodPointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start(pjp.toShortString());
        boolean isExceptionThrown = false;
        try {
            object = pjp.proceed();
        }
        catch (RuntimeException e) {
            try {
                isExceptionThrown = true;
                throw e;
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                StopWatch.TaskInfo taskInfo = stopWatch.getLastTaskInfo();
                String profileMessage = taskInfo.getTimeMillis() + " ms" + (isExceptionThrown ? " (thrown Exception)" : "");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\r\n\t#### ELAPSED TIME : " + profileMessage);
                }
                throw throwable;
            }
        }
        stopWatch.stop();
        StopWatch.TaskInfo taskInfo = stopWatch.getLastTaskInfo();
        String profileMessage = taskInfo.getTimeMillis() + " ms" + (isExceptionThrown ? " (thrown Exception)" : "");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\r\n\t#### ELAPSED TIME : " + profileMessage);
        }
        return object;
    }

    private static String niceNameForStart(JoinPoint joinPoint) {
        return joinPoint.getTarget().getClass().getSimpleName() + "#" + joinPoint.getSignature().getName() + BHiveServiceLoggingAspect.argsToString(joinPoint.getArgs());
    }

    private static String argsToString(Object[] args) {
        StringBuffer sb = new StringBuffer();
        if (args == null || args.length == 0) {
            return "\t\tno arguments.";
        }
        for (int i = 0; i < args.length; ++i) {
            sb.append(String.format("\r%n\t####  - args[%d]: %s", i, BHiveServiceLoggingAspect.argToString(args[i])));
        }
        return sb.toString();
    }

    private static String argToString(Object arg) {
        if (arg == null) {
            return "<null>";
        }
        return arg.toString();
    }

    private static String niceNameForEnd(JoinPoint joinPoint, Object retVal) {
        return joinPoint.getTarget().getClass().getSimpleName() + "#" + joinPoint.getSignature().getName() + BHiveServiceLoggingAspect.argsToString(joinPoint.getArgs()) + BHiveServiceLoggingAspect.retValToString(retVal);
    }

    private static String retValToString(Object retVal) {
        return "\r\n\t####  - return: " + (retVal == null ? "" : retVal.toString());
    }

    private String niceNameForException(JoinPoint joinPoint, Throwable ex) {
        return joinPoint.getTarget().getClass().getSimpleName() + "#" + joinPoint.getSignature().getName() + BHiveServiceLoggingAspect.argsToString(joinPoint.getArgs()) + this.exceptionToString(ex);
    }

    private String exceptionToString(Throwable ex) {
        return "\r\n\t####  - EXCEPTION : " + ex.toString();
    }
}

